/**
 * Copyright (c) 2024 Visa, Inc.
 *
 * This source code is licensed under the MIT license
 * https://github.com/visa/visa-chart-components/blob/master/LICENSE
 *
 **/
import{r as t,c as s,h as i,g as e}from"./p-b0ab226b.js";import{b as h}from"./p-bb2c1516.js";import{n as a}from"./p-42dcf457.js";import{q as r}from"./p-2c889405.js";import{U as o,s as n,e as l}from"./p-5fcd3c02.js";import{v as c}from"./p-b5f7528a.js";import{m as u}from"./p-f9c89fe4.js";import{m as f}from"./p-e1d72334.js";import{c as d}from"./p-3f5e41ff.js";import"./p-b6ae930f.js";import"./p-6e7316e2.js";const{propDefaultValues:p}=o;class m{}m.mainTitle="Heat Map Title";m.subTitle=p.subTitle.text;m.height=250;m.width=500;m.margin={top:250*.01,bottom:250*.01,right:500*.01,left:500*.01};m.padding={top:20,bottom:30,right:60,left:80};m.localization=p.localization;m.xAccessor="date";m.yAccessor="category";m.valueAccessor="value";m.shape="rect";m.hideAxisPath=p.showBaselineFalse;m.accessibility=p.accessibility;m.animationConfig=p.animationConfig;m.highestHeadingLevel=p.highestHeadingLevel;m.xAxis=p.xAxis;m.yAxis=p.yAxis;m.wrapLabel=p.wrapLabel;m.strokeWidth=p.strokeWidth2;m.colorPalette=p.colorPaletteSequential;m.colorSteps=p.colorSteps5;m.hoverStyle=p.hoverStyle;m.clickStyle=p.clickStyle;m.cursor=p.cursor;m.hoverOpacity=p.hoverOpacity;m.dataLabel=p.dataLabel;m.legend=p.legend;m.tooltipLabel=p.tooltipLabel;m.showTooltip=p.showTooltip;m.suppressEvents=p.suppressEvents;m.referenceLines=p.referenceLines;m.annotations=p.annotations;m.clickHighlight=p.clickHighlight;const g=".o-layout{width:100%;display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap}.o-layout--chart{width:100%}.is--vertical .o-layout--chart{width:90%}heat-map{cursor:default}heat-map .annotations{pointer-events:none}heat-map .annotations .handle{pointer-events:all}heat-map .screen-reader-info{position:absolute;left:-9999px;top:auto;width:1px;height:1px;overflow:hidden}heat-map .data-table-link{color:#767676;text-decoration:none;font-size:12px;margin-left:5%}heat-map .hidden{display:none}heat-map .axis{font-size:12px}heat-map .axis text{fill:#767676}heat-map .axis-label{text-anchor:middle;font:1rem sans-serif}heat-map .axis path{stroke:#767676}heat-map .axis .hidden{visibility:hidden}heat-map .heat-map-legend{font-size:1em;display:-ms-flexbox;display:flex;-ms-flex-direction:row;flex-direction:row;-ms-flex-pack:start;justify-content:flex-start}heat-map .heat-map-legend .legend{display:-ms-flexbox;display:flex;-ms-flex-direction:row;flex-direction:row;-ms-flex-pack:start;justify-content:flex-start}";const y=g;const{getGlobalInstances:b,configLocalization:x,getActiveLanguageString:v,calculateLuminance:A,prepareStrokeColorsFromScheme:W,verifyTextHasSpace:w,checkAttributeTransitions:T,createTextStrokeFilter:k,drawHoverStrokes:S,removeHoverStrokes:D,buildStrokes:L,convertColorsToTextures:C,findTagLevel:I,prepareRenderChange:E,initializeDescriptionRoot:O,initializeElementAccess:z,setElementFocusHandler:N,setElementAccessID:j,setAccessibilityController:K,hideNonessentialGroups:H,setAccessTitle:P,setAccessSubtitle:G,setAccessLongDescription:q,setAccessExecutiveSummary:V,setAccessPurpose:M,setAccessContext:$,setAccessStatistics:F,setAccessChartCounts:R,setAccessXAxis:X,setAccessYAxis:Y,setAccessStructure:_,setAccessAnnotation:U,retainAccessFocus:B,checkAccessFocus:J,setElementInteractionAccessState:Q,setAccessibilityDescriptionWidth:Z,autoTextColor:tt,annotate:st,chartAccessors:it,checkInteraction:et,checkClicked:ht,checkHovered:at,convertVisaColor:rt,drawAxis:ot,drawLegend:nt,drawTooltip:lt,formatStats:ct,formatDate:ut,getColors:ft,getLicenses:dt,getPadding:pt,getScopedData:mt,initTooltipStyle:gt,overrideTitleTooltip:yt,placeDataLabels:bt,scopeDataKeys:xt,transitionEndAll:vt,validateAccessibilityProps:At,validateLocalizationProps:Wt,setSubTitle:wt}=o;const Tt=class{constructor(i){t(this,i);this.clickEvent=s(this,"clickEvent",7);this.hoverEvent=s(this,"hoverEvent",7);this.mouseOutEvent=s(this,"mouseOutEvent",7);this.initialLoadEvent=s(this,"initialLoadEvent",7);this.initialLoadEndEvent=s(this,"initialLoadEndEvent",7);this.drawStartEvent=s(this,"drawStartEvent",7);this.drawEndEvent=s(this,"drawEndEvent",7);this.transitionEndEvent=s(this,"transitionEndEvent",7);this.shouldValidateAccessibility=true;this.shouldValidateLocalization=true;this.nest=[];this.datakeys=[];this.updated=true;this.shouldValidate=false;this.shouldUpdateData=false;this.shouldSetDimensions=false;this.shouldUpdateTableData=false;this.shouldUpdateScales=false;this.shouldResetRoot=false;this.shouldSetColors=false;this.shouldSetSubTitle=false;this.shouldValidateInteractionKeys=false;this.shouldFormatClickHighlight=false;this.shouldFormatHoverHighlight=false;this.shouldUpdateAnnotations=false;this.shouldUpdateXAxis=false;this.shouldUpdateYAxis=false;this.shouldSetGlobalSelections=false;this.shouldSetTestingAttributes=false;this.shouldEnterUpdateExit=false;this.shouldUpdateGeometries=false;this.shouldSetSelectionClass=false;this.shouldDrawInteractionState=false;this.shouldUpdateLegend=false;this.shouldUpdateCursor=false;this.shouldBindInteractivity=false;this.shouldUpdateLabels=false;this.shouldSetLabelOpacity=false;this.shouldSwapXAxis=false;this.shouldSwapYAxis=false;this.shouldUpdateDescriptionWrapper=false;this.shouldSetChartAccessibilityTitle=false;this.shouldSetChartAccessibilitySubtitle=false;this.shouldSetChartAccessibilityLongDescription=false;this.shouldSetChartAccessibilityExecutiveSummary=false;this.shouldSetChartAccessibilityStatisticalNotes=false;this.shouldSetChartAccessibilityStructureNotes=false;this.shouldSetParentSVGAccessibility=false;this.shouldSetGeometryAccessibilityAttributes=false;this.shouldSetGeometryAriaLabels=false;this.shouldSetGroupAccessibilityLabel=false;this.shouldSetChartAccessibilityPurpose=false;this.shouldSetChartAccessibilityContext=false;this.shouldRedrawWrapper=false;this.shouldSetTagLevels=false;this.shouldSetChartAccessibilityCount=false;this.shouldSetYAxisAccessibility=false;this.shouldSetXAxisAccessibility=false;this.shouldSetAnnotationAccessibility=false;this.shouldSetTextures=false;this.shouldSetStrokes=false;this.shouldSetLocalizationConfig=false;this.strokes={};this.topLevel="h2";this.bottomLevel="p";this.textTreatmentHandler=(t,s,i)=>{const e=!this.accessibility.hideTextures&&this.accessibility.showExperimentalTextures?this.fillColors(t.valueAccessor):this.rawHeat(t.valueAccessor);const h=tt(e);const a=n(i[s]);a.attr("filter",!a.classed("textIsMoving")?k({root:this.svg.node(),id:this.chartID,color:e}):null);return h};this.localization=m.localization;this.mainTitle=m.mainTitle;this.subTitle=m.subTitle;this.height=m.height;this.width=m.width;this.highestHeadingLevel=m.highestHeadingLevel;this.margin=m.margin;this.padding=m.padding;this.data=undefined;this.uniqueID=undefined;this.xAccessor=m.xAccessor;this.yAccessor=m.yAccessor;this.valueAccessor=m.valueAccessor;this.xKeyOrder=undefined;this.yKeyOrder=undefined;this.xAxis=m.xAxis;this.yAxis=m.yAxis;this.wrapLabel=m.wrapLabel;this.hideAxisPath=m.hideAxisPath;this.colorPalette=m.colorPalette;this.colors=undefined;this.colorSteps=m.colorSteps;this.hoverStyle=m.hoverStyle;this.clickStyle=m.clickStyle;this.cursor=m.cursor;this.shape=m.shape;this.hoverOpacity=m.hoverOpacity;this.animationConfig=m.animationConfig;this.strokeWidth=m.strokeWidth;this.dataLabel=m.dataLabel;this.dataKeyNames=undefined;this.showTooltip=m.showTooltip;this.tooltipLabel=m.tooltipLabel;this.accessibility=m.accessibility;this.legend=m.legend;this.annotations=m.annotations;this.maxValueOverride=undefined;this.minValueOverride=undefined;this.hoverHighlight=undefined;this.clickHighlight=m.clickHighlight;this.interactionKeys=undefined;this.suppressEvents=m.suppressEvents;this.unitTest=false}dataWatcher(t,s){this.updated=true;this.shouldUpdateData=true;this.shouldSetColors=true;this.shouldSetGlobalSelections=true;this.shouldSetTestingAttributes=true;this.shouldUpdateScales=true;this.shouldEnterUpdateExit=true;this.shouldUpdateTableData=true;this.shouldValidate=true;this.shouldUpdateGeometries=true;this.shouldUpdateXAxis=true;this.shouldUpdateYAxis=true;this.shouldUpdateLabels=true;this.shouldUpdateLegend=true;this.shouldDrawInteractionState=true;this.shouldUpdateAnnotations=true;this.shouldSetGeometryAccessibilityAttributes=true;this.shouldSetGeometryAriaLabels=true;this.shouldSetXAxisAccessibility=true;this.shouldSetYAxisAccessibility=true;this.shouldSetTextures=true;this.shouldSetStrokes=true;this.shouldSetLabelOpacity=true}idWatcher(t,s){console.error("Change detected in prop uniqueID from value "+s+" to value "+t+". This prop cannot be changed after component has loaded.")}headingWatcher(t,s){this.shouldRedrawWrapper=true;this.shouldSetTagLevels=true;this.shouldSetChartAccessibilityCount=true;this.shouldSetYAxisAccessibility=true;this.shouldSetXAxisAccessibility=true;this.shouldUpdateDescriptionWrapper=true;this.shouldSetAnnotationAccessibility=true;this.shouldSetSubTitle=true;this.shouldSetChartAccessibilityTitle=true;this.shouldSetChartAccessibilitySubtitle=true;this.shouldSetChartAccessibilityLongDescription=true;this.shouldSetChartAccessibilityContext=true;this.shouldSetChartAccessibilityExecutiveSummary=true;this.shouldSetChartAccessibilityPurpose=true;this.shouldSetChartAccessibilityStatisticalNotes=true;this.shouldSetChartAccessibilityStructureNotes=true}titleWatcher(t,s){this.shouldValidate=true;this.shouldUpdateDescriptionWrapper=true;this.shouldSetChartAccessibilityTitle=true;this.shouldSetParentSVGAccessibility=true}subtitleWatcher(t,s){this.shouldSetSubTitle=true;this.shouldSetChartAccessibilitySubtitle=true;this.shouldSetParentSVGAccessibility=true}layoutWatcher(t,s){this.shouldSetDimensions=true;this.shouldUpdateScales=true;this.shouldSetTextures=true;this.shouldResetRoot=true;this.shouldUpdateGeometries=true;this.shouldUpdateXAxis=true;this.shouldUpdateYAxis=true;this.shouldUpdateLabels=true;this.shouldUpdateLegend=true;this.shouldUpdateAnnotations=true;this.shouldSetLabelOpacity=true}xAccessorWatcher(t,s){this.shouldUpdateData=true;this.shouldSetColors=true;this.shouldUpdateScales=true;this.shouldSetGlobalSelections=true;this.shouldFormatClickHighlight=true;this.shouldFormatHoverHighlight=true;this.shouldDrawInteractionState=true;this.shouldEnterUpdateExit=true;this.shouldUpdateTableData=true;this.shouldUpdateGeometries=true;this.shouldUpdateXAxis=true;this.shouldUpdateLabels=true;this.shouldUpdateLegend=true;this.shouldUpdateAnnotations=true;this.shouldSetGeometryAriaLabels=true;this.shouldSetXAxisAccessibility=true;this.shouldSetTextures=true;this.shouldSetStrokes=true;this.shouldSetLabelOpacity=true}yAccessorWatcher(t,s){this.shouldUpdateData=true;this.shouldSetColors=true;this.shouldUpdateScales=true;this.shouldSetGlobalSelections=true;this.shouldFormatClickHighlight=true;this.shouldFormatHoverHighlight=true;this.shouldDrawInteractionState=true;this.shouldEnterUpdateExit=true;this.shouldUpdateTableData=true;this.shouldUpdateGeometries=true;this.shouldUpdateYAxis=true;this.shouldUpdateLabels=true;this.shouldUpdateLegend=true;this.shouldUpdateAnnotations=true;this.shouldSetGeometryAriaLabels=true;this.shouldSetYAxisAccessibility=true;this.shouldSetTextures=true;this.shouldSetStrokes=true;this.shouldSetLabelOpacity=true}groupAccessorWatcher(t,s){this.shouldUpdateData=true;this.shouldUpdateTableData=true;this.shouldSetColors=true;this.shouldUpdateScales=true;this.shouldSetGlobalSelections=true;this.shouldUpdateGeometries=true;this.shouldDrawInteractionState=true;this.shouldUpdateLegend=true;this.shouldSetLabelOpacity=true;this.shouldUpdateLabels=true;this.shouldSetGeometryAriaLabels=true;if(!(this.interactionKeys&&this.interactionKeys.length)){this.shouldValidateInteractionKeys=true;this.shouldSetSelectionClass=true}this.shouldSetTextures=true;this.shouldSetStrokes=true}xKeyOrderWatcher(t,s){this.shouldUpdateData=true;this.shouldUpdateScales=true;this.shouldSetGlobalSelections=true;this.shouldSetTestingAttributes=true;this.shouldDrawInteractionState=true;this.shouldUpdateTableData=true;this.shouldUpdateGeometries=true;this.shouldUpdateXAxis=true;this.shouldUpdateLabels=true;this.shouldUpdateLegend=true;this.shouldUpdateAnnotations=true;this.shouldSetGeometryAriaLabels=true;this.shouldSetGeometryAccessibilityAttributes=true;this.shouldSetXAxisAccessibility=true;this.shouldSetTextures=true;this.shouldSetStrokes=true}yKeyOrderWatcher(t,s){this.shouldUpdateData=true;this.shouldUpdateScales=true;this.shouldSetGlobalSelections=true;this.shouldSetTestingAttributes=true;this.shouldDrawInteractionState=true;this.shouldUpdateTableData=true;this.shouldUpdateGeometries=true;this.shouldUpdateYAxis=true;this.shouldUpdateLabels=true;this.shouldUpdateLegend=true;this.shouldUpdateAnnotations=true;this.shouldSetGeometryAriaLabels=true;this.shouldSetGeometryAccessibilityAttributes=true;this.shouldSetYAxisAccessibility=true;this.shouldSetTextures=true;this.shouldSetStrokes=true}xAxisWatcher(t,s){const i=t&&t.format?t.format:false;const e=s&&s.format?s.format:false;const h=t&&t.placement?t.placement:false;const a=s&&s.placement?s.placement:false;if(i!==e){this.shouldUpdateData=true;this.shouldSetColors=true;this.shouldUpdateScales=true;this.shouldSetTextures=true;this.shouldSetGlobalSelections=true;this.shouldFormatClickHighlight=true;this.shouldFormatHoverHighlight=true;this.shouldDrawInteractionState=true;this.shouldEnterUpdateExit=true;this.shouldUpdateTableData=true;this.shouldUpdateGeometries=true;this.shouldUpdateLabels=true;this.shouldUpdateLegend=true;this.shouldUpdateAnnotations=true}if(h!==a){this.shouldSwapXAxis=true}this.shouldUpdateXAxis=true;this.shouldSetXAxisAccessibility=true}yAxisWatcher(t,s){const i=t&&t.format?t.format:false;const e=s&&s.format?s.format:false;const h=t&&t.placement?t.placement:false;const a=s&&s.placement?s.placement:false;if(i!==e){this.shouldUpdateData=true;this.shouldSetColors=true;this.shouldUpdateScales=true;this.shouldSetTextures=true;this.shouldSetGlobalSelections=true;this.shouldFormatClickHighlight=true;this.shouldFormatHoverHighlight=true;this.shouldDrawInteractionState=true;this.shouldEnterUpdateExit=true;this.shouldUpdateTableData=true;this.shouldUpdateGeometries=true;this.shouldUpdateLabels=true;this.shouldUpdateLegend=true;this.shouldUpdateAnnotations=true}if(h!==a){this.shouldSwapYAxis=true}this.shouldUpdateYAxis=true;this.shouldSetYAxisAccessibility=true}wrapLabelWatcher(t,s){this.shouldUpdateXAxis=true;this.shouldUpdateYAxis=true}hideAxisPathWatcher(t,s){this.shouldUpdateXAxis=true;this.shouldUpdateYAxis=true}colorsWatcher(t,s){this.shouldSetColors=true;this.shouldUpdateScales=true;this.shouldUpdateGeometries=true;this.shouldUpdateLegend=true;this.shouldDrawInteractionState=true;this.shouldSetTextures=true;this.shouldSetStrokes=true}hoverStyleWatcher(t,s){this.shouldDrawInteractionState=true;this.shouldSetLabelOpacity=true;this.shouldSetStrokes=true}clickStyleWatcher(t,s){this.shouldDrawInteractionState=true;this.shouldSetLabelOpacity=true;this.shouldSetStrokes=true}shapeWatcher(t,s){this.shouldUpdateGeometries=true}cursorWatcher(t,s){this.shouldUpdateCursor=true}strokeWidthWatcher(t,s){this.shouldUpdateGeometries=true;this.shouldUpdateScales=true;this.shouldSetTextures=true;this.shouldUpdateGeometries=true;this.shouldSetStrokes=true}hoverOpacityWatcher(t,s){this.shouldSetLabelOpacity=true;this.shouldDrawInteractionState=true}labelWatcher(t,s){this.shouldUpdateLabels=true;this.shouldUpdateTableData=true;const i=t&&t.visible;const e=s&&s.visible;if(i!==e){this.shouldSetLabelOpacity=true}}showTooltipWatcher(t,s){}tooltipLabelWatcher(t,s){this.shouldUpdateTableData=true;this.shouldSetParentSVGAccessibility=true;this.shouldSetGeometryAriaLabels=true}legendWatcher(t,s){this.shouldUpdateLegend=true}suppressWatcher(t,s){this.shouldBindInteractivity=true;this.shouldUpdateCursor=true;this.shouldSetGeometryAriaLabels=true;this.shouldSetParentSVGAccessibility=true;this.shouldUpdateDescriptionWrapper=true;this.shouldRedrawWrapper=true;this.shouldValidate=true;this.shouldSetSubTitle=true;this.shouldSetChartAccessibilityTitle=true;this.shouldSetChartAccessibilitySubtitle=true;this.shouldSetChartAccessibilityLongDescription=true;this.shouldSetChartAccessibilityContext=true;this.shouldSetChartAccessibilityExecutiveSummary=true;this.shouldSetChartAccessibilityPurpose=true;this.shouldSetChartAccessibilityStatisticalNotes=true;this.shouldSetChartAccessibilityStructureNotes=true}annotationsWatcher(t,s){this.shouldValidate=true;this.shouldUpdateAnnotations=true;this.shouldSetAnnotationAccessibility=true}accessibilityWatcher(t,s){this.shouldValidate=true;const i=t&&t.title?t.title:false;const e=s&&s.title?s.title:false;if(i!==e){this.shouldUpdateDescriptionWrapper=true;this.shouldSetChartAccessibilityTitle=true;this.shouldSetParentSVGAccessibility=true}const h=t&&t.executiveSummary?t.executiveSummary:false;const a=s&&s.executiveSummary?s.executiveSummary:false;if(h!==a){this.shouldSetChartAccessibilityExecutiveSummary=true}const r=t&&t.purpose?t.purpose:false;const o=s&&s.purpose?s.purpose:false;if(r!==o){this.shouldSetChartAccessibilityPurpose=true}const n=t&&t.longDescription?t.longDescription:false;const l=s&&s.longDescription?s.longDescription:false;if(n!==l){this.shouldSetChartAccessibilityLongDescription=true}const c=t&&t.contextExplanation?t.contextExplanation:false;const u=s&&s.contextExplanation?s.contextExplanation:false;if(c!==u){this.shouldSetChartAccessibilityContext=true}const f=t&&t.statisticalNotes?t.statisticalNotes:false;const d=s&&s.statisticalNotes?s.statisticalNotes:false;if(f!==d){this.shouldSetChartAccessibilityStatisticalNotes=true}const p=t&&t.structureNotes?t.structureNotes:false;const m=s&&s.structureNotes?s.structureNotes:false;if(p!==m){this.shouldSetChartAccessibilityStructureNotes=true}const g=t&&t.includeDataKeyNames;const y=s&&s.includeDataKeyNames;const b=t&&t.elementDescriptionAccessor?t.elementDescriptionAccessor:false;const x=s&&s.elementDescriptionAccessor?s.elementDescriptionAccessor:false;if(g!==y||b!==x){if(g!==y){this.shouldSetGroupAccessibilityLabel=true}this.shouldSetGeometryAriaLabels=true;this.shouldSetParentSVGAccessibility=true}const v=t&&t.hideTextures?t.hideTextures:false;const A=s&&s.hideTextures?s.hideTextures:false;const W=t&&t.showExperimentalTextures?t.showExperimentalTextures:false;const w=s&&s.showExperimentalTextures?s.showExperimentalTextures:false;if(v!==A||W!==w){this.shouldSetTextures=true;this.shouldUpdateLegend=true;this.shouldSetStrokes=true;this.shouldDrawInteractionState=true}const T=t&&t.showSmallLabels?t.showSmallLabels:false;const k=s&&s.showSmallLabels?s.showSmallLabels:false;if(T!==k){this.shouldSetLabelOpacity=true}const S=t&&t.hideStrokes?t.hideStrokes:false;const D=s&&s.hideStrokes?s.hideStrokes:false;if(S!==D){this.shouldUpdateLegend=true;this.shouldSetStrokes=true;this.shouldDrawInteractionState=true}const L=t&&t.keyboardNavConfig&&t.keyboardNavConfig.disabled?t.keyboardNavConfig.disabled:false;const C=s&&s.keyboardNavConfig&&s.keyboardNavConfig.disabled?s.keyboardNavConfig.disabled:false;const I=t&&t.elementsAreInterface?t.elementsAreInterface:false;const E=s&&s.elementsAreInterface?s.elementsAreInterface:false;if(L!==C||I!==E){this.shouldSetGeometryAriaLabels=true;this.shouldSetParentSVGAccessibility=true;this.shouldUpdateDescriptionWrapper=true;this.shouldRedrawWrapper=true;this.shouldSetChartAccessibilityTitle=true;this.shouldSetChartAccessibilitySubtitle=true;this.shouldSetChartAccessibilityLongDescription=true;this.shouldSetChartAccessibilityContext=true;this.shouldSetChartAccessibilityExecutiveSummary=true;this.shouldSetChartAccessibilityPurpose=true;this.shouldSetChartAccessibilityStatisticalNotes=true;this.shouldSetChartAccessibilityStructureNotes=true}if(I!==E){this.shouldSetSelectionClass=true}}localizationWatcher(t,s){this.shouldValidate=true;const i=t&&t.language?t.language:false;const e=s&&s.language?s.language:false;if(i!==e){this.shouldSetLocalizationConfig=true;this.shouldUpdateTableData=true;this.shouldRedrawWrapper=true;this.shouldUpdateDescriptionWrapper=true;this.shouldSetChartAccessibilityCount=true;this.shouldSetYAxisAccessibility=true;this.shouldSetXAxisAccessibility=true;this.shouldUpdateDescriptionWrapper=true;this.shouldSetGeometryAriaLabels=true;this.shouldSetParentSVGAccessibility=true}const h=t&&t.numeralLocale?t.numeralLocale:false;const a=s&&s.numeralLocale?s.numeralLocale:false;if(h!==a){this.shouldSetLocalizationConfig=true;this.shouldUpdateTableData=true;this.shouldRedrawWrapper=true;this.shouldUpdateDescriptionWrapper=true;this.shouldSetChartAccessibilityCount=true;this.shouldSetYAxisAccessibility=true;this.shouldSetXAxisAccessibility=true;this.shouldUpdateDescriptionWrapper=true;this.shouldSetGeometryAriaLabels=true;this.shouldSetParentSVGAccessibility=true}}valueOverrideWatcher(t,s){this.shouldUpdateScales=true;this.shouldUpdateGeometries=true;this.shouldUpdateLabels=true;this.shouldUpdateLegend=true;this.shouldUpdateAnnotations=true;this.shouldSetTextures=true}clickWatcher(t,s){this.shouldFormatClickHighlight=true;this.shouldDrawInteractionState=true;this.shouldSetLabelOpacity=true;this.shouldSetSelectionClass=true}hoverWatcher(t,s){this.shouldFormatHoverHighlight=true;this.shouldDrawInteractionState=true;this.shouldSetLabelOpacity=true}interactionWatcher(t,s){this.shouldValidateInteractionKeys=true;this.shouldDrawInteractionState=true;this.shouldSetLabelOpacity=true;this.shouldSetSelectionClass=true;this.shouldUpdateTableData=true;this.shouldSetGeometryAriaLabels=true}dataKeyNamesWatcher(t,s){this.shouldUpdateXAxis=true;this.shouldSetXAxisAccessibility=true;this.shouldUpdateYAxis=true;this.shouldSetYAxisAccessibility=true;this.shouldSetParentSVGAccessibility=true;this.shouldSetGroupAccessibilityLabel=true;this.shouldSetGeometryAriaLabels=true}unitTestWatcher(t,s){this.shouldSetTestingAttributes=true}componentWillLoad(){const t=this.uniqueID||"heat-map-"+c();this.initialLoadEvent.emit({chartID:t});return new Promise((s=>{this.duration=0;this.defaults=true;this.chartID=t;this.heatMapEl.id=this.chartID;this.setLocalizationConfig();this.setTagLevels();this.prepareData();this.setDimensions();this.setColors();this.prepareScales();this.validateInteractionKeys();this.setTableData();this.shouldValidateAccessibilityProps();this.shouldValidateLocalizationProps();this.formatClickHighlight();this.formatHoverHighlight();s("component will load")}))}componentWillUpdate(){return new Promise((t=>{t("component will update")}))}componentDidLoad(){return new Promise((t=>{this.renderRootElements();this.setTooltipInitialStyle();this.setChartDescriptionWrapper();this.setChartAccessibilityTitle();this.setChartAccessibilitySubtitle();this.setChartAccessibilityLongDescription();this.setChartAccessibilityExecutiveSummary();this.setChartAccessibilityPurpose();this.setChartAccessibilityContext();this.setChartAccessibilityStatisticalNotes();this.setChartAccessibilityStructureNotes();this.setParentSVGAccessibility();this.reSetRoot();this.setTextures();this.setStrokes();this.setSubTitleElements();this.setGlobalSelections();this.setTestingAttributes();this.enterGeometries();this.updateGeometries();this.exitGeometries();this.enterDataLabels();this.updateDataLabels();this.exitDataLabels();this.drawGeometries();this.setChartCountAccessibility();this.setGeometryAccessibilityAttributes();this.setGeometryAriaLabels();this.drawDataLabels();this.drawLegendElements();this.setSelectedClass();this.updateInteractionState();this.bindInteractivity();this.drawAnnotations();this.setAnnotationAccessibility();this.drawXAxis();this.setXAxisAccessibility();this.drawYAxis();this.setYAxisAccessibility();H(this.root.node(),this.map.node());this.setGroupAccessibilityID();this.onChangeHandler();this.defaults=false;t("component did load")})).then((()=>this.initialLoadEndEvent.emit({chartID:this.chartID})))}componentDidUpdate(){return new Promise((t=>{this.duration=!this.animationConfig||!this.animationConfig.disabled?750:0;if(this.shouldUpdateDescriptionWrapper){this.setChartDescriptionWrapper();this.shouldUpdateDescriptionWrapper=false}if(this.shouldSetChartAccessibilityCount){this.setChartCountAccessibility();this.shouldSetChartAccessibilityCount=false}if(this.shouldSetChartAccessibilityTitle){this.setChartAccessibilityTitle();this.shouldSetChartAccessibilityTitle=false}if(this.shouldSetChartAccessibilitySubtitle){this.setChartAccessibilitySubtitle();this.shouldSetChartAccessibilitySubtitle=false}if(this.shouldSetChartAccessibilityLongDescription){this.setChartAccessibilityLongDescription();this.shouldSetChartAccessibilityLongDescription=false}if(this.shouldSetChartAccessibilityExecutiveSummary){this.setChartAccessibilityExecutiveSummary();this.shouldSetChartAccessibilityExecutiveSummary=false}if(this.shouldSetChartAccessibilityPurpose){this.setChartAccessibilityPurpose();this.shouldSetChartAccessibilityPurpose=false}if(this.shouldSetChartAccessibilityContext){this.setChartAccessibilityContext();this.shouldSetChartAccessibilityContext=false}if(this.shouldSetChartAccessibilityStatisticalNotes){this.setChartAccessibilityStatisticalNotes();this.shouldSetChartAccessibilityStatisticalNotes=false}if(this.shouldSetChartAccessibilityStructureNotes){this.setChartAccessibilityStructureNotes();this.shouldSetChartAccessibilityStructureNotes=false}if(this.shouldSetParentSVGAccessibility){this.setParentSVGAccessibility();this.shouldSetParentSVGAccessibility=false}if(this.shouldResetRoot){this.reSetRoot();this.shouldResetRoot=false}if(this.shouldSetTextures){this.setTextures();this.shouldSetTextures=false}if(this.shouldSetStrokes){this.setStrokes();this.shouldSetStrokes=false}if(this.shouldSetGlobalSelections){this.setGlobalSelections();this.shouldSetGlobalSelections=false}if(this.shouldSetTestingAttributes){this.setTestingAttributes();this.shouldSetTestingAttributes=false}if(this.shouldSetSubTitle){this.setSubTitleElements();this.shouldSetSubTitle=false}if(this.shouldEnterUpdateExit){this.enterGeometries();this.updateGeometries();this.exitGeometries();this.enterDataLabels();this.updateDataLabels();this.exitDataLabels();this.shouldEnterUpdateExit=false}if(this.shouldUpdateGeometries){this.drawGeometries();this.shouldUpdateGeometries=false}if(this.shouldSetGeometryAccessibilityAttributes){this.setGeometryAccessibilityAttributes();this.shouldSetGeometryAccessibilityAttributes=false}if(this.shouldSetGeometryAriaLabels){this.setGeometryAriaLabels();this.shouldSetGeometryAriaLabels=false}if(this.shouldSetGroupAccessibilityLabel){this.setGroupAccessibilityID();this.shouldSetGroupAccessibilityLabel=false}if(this.shouldUpdateLegend){this.drawLegendElements();this.shouldUpdateLegend=false}if(this.shouldUpdateLabels){this.drawDataLabels();this.shouldUpdateLabels=false}if(this.shouldDrawInteractionState){this.updateInteractionState();this.shouldDrawInteractionState=false}if(this.shouldSetLabelOpacity){this.setLabelOpacity();this.shouldSetLabelOpacity=false}if(this.shouldSetSelectionClass){this.setSelectedClass();this.shouldSetSelectionClass=false}if(this.shouldUpdateCursor){this.updateCursor();this.shouldUpdateCursor=false}if(this.shouldBindInteractivity){this.bindInteractivity();this.shouldBindInteractivity=false}if(this.shouldUpdateAnnotations){this.drawAnnotations();this.shouldUpdateAnnotations=false}if(this.shouldSetAnnotationAccessibility){this.setAnnotationAccessibility();this.shouldSetAnnotationAccessibility=false}if(this.shouldSwapXAxis){this.drawXAxis(true);this.shouldSwapXAxis=false}if(this.shouldSwapYAxis){this.drawYAxis(true);this.shouldSwapYAxis=false}if(this.shouldUpdateXAxis){this.drawXAxis();this.shouldUpdateXAxis=false}if(this.shouldSetXAxisAccessibility){this.setXAxisAccessibility();this.shouldSetXAxisAccessibility=false}if(this.shouldUpdateYAxis){this.drawYAxis();this.shouldUpdateYAxis=false}if(this.shouldSetYAxisAccessibility){this.setYAxisAccessibility();this.shouldSetYAxisAccessibility=false}this.onChangeHandler();t("component did update")})).then((()=>this.drawEndEvent.emit({chartID:this.chartID})))}shouldValidateLocalizationProps(){const t=b();const s=t.i18Next.language;const i=t.i18Next.getResourceBundle(s);const e=t.numeral.localeData();if(this.shouldValidateLocalization&&!this.localization.skipValidation){this.shouldValidateLocalization=false;Wt(this.chartID,Object.assign(Object.assign({},this.localization),{language:i,numeralLocale:e}))}}shouldValidateAccessibilityProps(){if(this.shouldValidateAccessibility&&!this.accessibility.disableValidation){this.shouldValidateAccessibility=false;At(this.chartID,Object.assign({},this.accessibility),{annotations:this.annotations,data:this.data,uniqueID:this.uniqueID,context:{mainTitle:this.mainTitle,onClickEvent:this.suppressEvents?undefined:this.clickEvent.emit}})}}formatClickHighlight(){if(this.clickHighlight){this.clickHighlight.map((t=>{if(!t["xAccessor"]||!t["yAccessor"]){t["xAccessor"]=t[this.xAccessor]instanceof Date?ut({date:t[this.xAccessor],format:this.xAxis.format,offsetTimezone:true}):t[this.xAccessor];t["yAccessor"]=t[this.yAccessor]instanceof Date?ut({date:t[this.yAccessor],format:this.yAxis.format,offsetTimezone:true}):t[this.yAccessor]}}))}}formatHoverHighlight(){if(this.hoverHighlight){if(!this.hoverHighlight["xAccessor"]||!this.hoverHighlight["yAccessor"]){this.hoverHighlight["xAccessor"]=this.hoverHighlight[this.xAccessor]instanceof Date?ut({date:this.hoverHighlight[this.xAccessor],format:this.xAxis.format,offsetTimezone:true}):this.hoverHighlight[this.xAccessor];this.hoverHighlight["yAccessor"]=this.hoverHighlight[this.yAccessor]instanceof Date?ut({date:this.hoverHighlight[this.yAccessor],format:this.yAxis.format,offsetTimezone:true}):this.hoverHighlight[this.yAccessor]}}}getLanguageString(){return v(this.localization)}setLocalizationConfig(){x(this.localization)}setDimensions(){this.padding=typeof this.padding==="string"?pt(this.padding):this.padding;this.innerHeight=this.height-this.margin.top-this.margin.bottom;this.innerWidth=this.width-this.margin.left-this.margin.right;this.innerPaddedHeight=this.innerHeight-this.padding.top-this.padding.bottom;this.innerPaddedWidth=this.innerWidth-this.padding.left-this.padding.right}validateInteractionKeys(){if(this.interactionKeys&&this.interactionKeys.length){if(this.interactionKeys.includes(this.xAccessor)||this.interactionKeys.includes(this.yAccessor)){const t=[];this.interactionKeys.map((s=>{const i=s===this.xAccessor?"xAccessor":s===this.yAccessor?"yAccessor":s;t.push(i)}));this.innerInteractionKeys=t}}else{this.innerInteractionKeys=["xAccessor","yAccessor"]}}prepareScales(){const t=(this.minValueOverride||this.minValueOverride===0)&&this.minValueOverride<u(this.preppedData,(t=>t.valueAccessor))?this.minValueOverride:u(this.preppedData,(t=>t.valueAccessor));const s=(this.maxValueOverride||this.maxValueOverride===0)&&this.maxValueOverride>f(this.preppedData,(t=>t.valueAccessor))?this.maxValueOverride:f(this.preppedData,(t=>t.valueAccessor));this.x=h().domain(this.xKeyOrder?this.xKeyOrder:this.preppedData.map((t=>t.xAccessor))).range([0,this.innerPaddedWidth]);this.x.padding(this.strokeWidth?this.strokeWidth/this.x.bandwidth():0);this.y=h().domain(this.yKeyOrder?this.yKeyOrder:this.preppedData.map((t=>t.yAccessor))).range([0,this.innerPaddedHeight]);this.y.padding(this.strokeWidth?this.strokeWidth/this.y.bandwidth():0);this.heat=r().domain([t,s]);const i=[];const e=[];let a=0;const o=Math.ceil(this.preparedColors.length/2);const n=this.colorPalette&&this.colorPalette.includes("diverging");const l=this.colorPalette&&this.colorPalette.includes("dark");this.preparedColors.forEach((t=>{const s=W(t,a,this.preparedColors,n?"diverging":"sequential");if(n){const t=A(s.fillColor);const h=A(s.textureColor);const r=t>h?s.textureColor:s.fillColor;const o=t<h?s.textureColor:s.fillColor;if(this.preparedColors.length%2&&a===(this.preparedColors.length-1)/2){e.push(l?r:o);i.push(l?o:r)}else{i.push(l?r:o);e.push(l?o:r)}}else{if(a+1<o){e.push(this.preparedColors[0]);i.push(this.preparedColors[this.preparedColors.length-1])}else{i.push(this.preparedColors[0]);e.push(this.preparedColors[this.preparedColors.length-1])}}a++}));this.fillColors=r().domain([t,s]).range(e);this.strokeColors=r().domain([t,s]).range(i);this.rawHeat=r().domain([t,s]).range(this.preparedColors);this.updateCheck=true}setSubTitleElements(){wt({root:this.subTitleG,subTitle:this.subTitle})}setColors(){this.preparedColors=this.colors?rt(this.colors):ft(this.colorPalette,this.colorSteps)}setTextures(){const t=this.colorPalette&&this.colorPalette.includes("diverging")?"diverging":"sequential";const s=t==="diverging"?11:9;if(this.accessibility.hideTextures||this.colorSteps>s||!this.accessibility.showExperimentalTextures){this.colorArr=this.preparedColors}else{const s=C({colors:this.preparedColors,rootSVG:this.svg.node(),id:this.chartID,scheme:t,disableTransitions:!this.duration});this.colorArr=s}this.heat.range(this.colorArr)}setStrokes(){const t=Object.assign(Object.assign({},this.clickStyle),{color:undefined});const s=Object.assign(Object.assign({},this.hoverStyle),{color:undefined});this.strokes=L({root:this.svg.node(),id:this.chartID,colors:!this.accessibility.hideTextures&&this.accessibility.showExperimentalTextures?this.fillColors.range():this.preparedColors,clickStyle:t,hoverStyle:s,strokeOverride:!this.accessibility.hideTextures&&this.accessibility.showExperimentalTextures?this.strokeColors.range():undefined})}setTableData(){const t=xt(this,it,"heat-map");this.tableData=mt(this.data,t);this.tableColumns=Object.keys(t)}prepareData(){if(this.updateCheck){this.interpolating=this.preppedData;const t=this.x.domain();const s=this.x.range();const i=this.y.domain();const e=this.y.range();this.interpolating.x=h().domain(t).range(s);this.interpolating.y=h().domain(i).range(e)}this.preppedData=this.data.map((t=>{const s=Object.assign({},t);s["valueAccessor"]=parseFloat(t[this.valueAccessor]);s["xAccessor"]=t[this.xAccessor]instanceof Date?ut({date:t[this.xAccessor],format:this.xAxis.format,offsetTimezone:true}):t[this.xAccessor];s["yAccessor"]=t[this.yAccessor]instanceof Date?ut({date:t[this.yAccessor],format:this.yAxis.format,offsetTimezone:true}):t[this.yAccessor];return s}));this.nest=a().key((t=>t[this.yAccessor])).entries(this.preppedData);this.datakeys=this.nest.map((t=>t.key))}reSetRoot(){const t=E({selection:this.svg,duration:this.duration,namespace:"root_reset",easing:d});t.attr("width",this.width).attr("height",this.height).attr("viewBox","0 0 "+this.width+" "+this.height);const s=E({selection:this.root,duration:this.duration,namespace:"root_reset",easing:d});s.attr("transform",`translate(${this.margin.left}, ${this.margin.top})`);const i=E({selection:this.rootG,duration:this.duration,namespace:"root_reset",easing:d});i.attr("transform",`translate(${this.padding.left}, ${this.padding.top})`);Z(this.chartID,this.width)}drawXAxis(t){const s=this.xAxis.label||this.xAxis.label===""?this.xAxis.label:this.dataKeyNames&&this.dataKeyNames[this.xAccessor]?this.dataKeyNames[this.xAccessor]:this.xAxis.label;ot({root:this.rootG,height:this.innerPaddedHeight,width:this.innerPaddedWidth,axisScale:this.x,top:this.xAxis.placement==="top",wrapLabel:this.wrapLabel?this.x.bandwidth():"",format:this.xAxis.format,tickInterval:this.xAxis.tickInterval,label:s,padding:this.padding,hide:t||!this.xAxis.visible,duration:this.duration,hidePath:this.hideAxisPath})}drawYAxis(t){const s=this.yAxis.label&&this.yAxis.label!==""?this.yAxis.label:this.dataKeyNames&&this.dataKeyNames[this.yAccessor]?this.dataKeyNames[this.yAccessor]:this.yAxis.label;ot({root:this.rootG,height:this.innerPaddedHeight,width:this.innerPaddedWidth,axisScale:this.y,left:this.yAxis.placement!=="right",right:this.yAxis.placement==="right",format:this.yAxis.format,wrapLabel:this.wrapLabel?this.padding.left||100:"",tickInterval:this.yAxis.tickInterval,label:s,padding:this.padding,hide:t||!this.yAxis.visible,duration:this.duration,hidePath:this.hideAxisPath})}setXAxisAccessibility(){const t=this.xAxis.label||this.xAxis.label===""?this.xAxis.label:this.dataKeyNames&&this.dataKeyNames[this.xAccessor]?this.dataKeyNames[this.xAccessor]:this.xAxis.label;X({rootEle:this.heatMapEl,hasXAxis:this.xAxis?this.xAxis.visible:false,xAxis:this.x||false,xAxisLabel:t?t:""})}setYAxisAccessibility(){const t=this.yAxis.label&&this.yAxis.label!==""?this.yAxis.label:this.dataKeyNames&&this.dataKeyNames[this.yAccessor]?this.dataKeyNames[this.yAccessor]:this.yAxis.label;Y({rootEle:this.heatMapEl,hasYAxis:this.yAxis?this.yAxis.visible:false,yAxis:this.y||false,yAxisLabel:t?t:""})}renderRootElements(){this.svg=n(this.heatMapEl).select(".visa-viz-d3-heat-map-container").append("svg").attr("width",this.width).attr("height",this.height).attr("viewBox","0 0 "+this.width+" "+this.height);this.root=this.svg.append("g").attr("id","visa-viz-margin-container-g-"+this.chartID);this.rootG=this.root.append("g").attr("id","visa-viz-padding-container-g-"+this.chartID);this.map=this.rootG.append("g").attr("class","map-group");this.labelG=this.rootG.append("g").attr("class","heat-map-dataLabel-group");this.legendG=n(this.heatMapEl).select(".heat-map-legend").append("svg");this.subTitleG=n(this.heatMapEl).select(".heat-sub-title");this.tooltipG=n(this.heatMapEl).select(".heat-map-tooltip")}setGlobalSelections(){this.xAxisElement=this.rootG.selectAll(".bottom");const t=this.map.selectAll(".row").data(this.nest,(t=>t.key));this.enterRowWrappers=t.enter().append("g");this.exitRowWrappers=t.exit();this.updateRowWrappers=t.merge(this.enterRowWrappers);const s=this.updateRowWrappers.selectAll(".grid").data((t=>t.values),(t=>t.xAccessor+t.yAccessor));this.enter=s.enter().append("rect");this.exit=s.exit();this.update=s.merge(this.enter);this.exitSize=this.exit.size();this.enterSize=this.enter.size();this.exitSize+=this.exitRowWrappers.selectAll(".grid").size();const i=this.labelG.selectAll("g").data(this.nest,(t=>t.key));this.enteringLabelGroups=i.enter().append("g");this.exitingLabelGroups=i.exit();this.updatingLabelGroups=i.merge(this.enteringLabelGroups);const e=this.updatingLabelGroups.selectAll("text").data((t=>t.values),(t=>t.xAccessor+t.yAccessor));this.enterLabels=e.enter().append("text");this.exitLabels=e.exit();this.updateLabels=e.merge(this.enterLabels)}setTestingAttributes(){if(this.unitTest){n(this.heatMapEl).select(".visa-viz-d3-heat-map-container").attr("data-testid","chart-container");n(this.heatMapEl).select(".heat-main-title").attr("data-testid","main-title");n(this.heatMapEl).select(".heat-sub-title").attr("data-testid","sub-title");this.svg.attr("data-testid","root-svg");this.root.attr("data-testid","margin-container");this.rootG.attr("data-testid","padding-container");this.legendG.attr("data-testid","legend-container");this.tooltipG.attr("data-testid","tooltip-container");this.map.attr("data-testid","map-group");this.labelG.attr("data-testid","dataLabel-group");this.svg.select("defs").attr("data-testid","pattern-defs");this.updateRowWrappers.attr("data-testid","map-row").attr("data-id",(t=>`row-${t.key}`));this.updateLabels.attr("data-testid","dataLabel").attr("data-id",(t=>`label-${t[this.xAccessor]}-${t[this.yAccessor]}`));this.update.attr("data-testid","marker").attr("data-id",(t=>`marker-${t[this.xAccessor]}-${t[this.yAccessor]}`))}else{n(this.heatMapEl).select(".visa-viz-d3-heat-map-container").attr("data-testid",null);n(this.heatMapEl).select(".heat-main-title").attr("data-testid",null);n(this.heatMapEl).select(".heat-sub-title").attr("data-testid",null);this.svg.attr("data-testid",null);this.root.attr("data-testid",null);this.rootG.attr("data-testid",null);this.legendG.attr("data-testid",null);this.tooltipG.attr("data-testid",null);this.map.attr("data-testid",null);this.labelG.attr("data-testid",null);this.svg.select("defs").attr("data-testid",null);this.updateRowWrappers.attr("data-testid",null).attr("data-id",null);this.updateLabels.attr("data-testid",null).attr("data-id",null);this.update.attr("data-testid",null).attr("data-id",null)}}enterGeometries(){this.enter.interrupt();this.enterRowWrappers.attr("class","row").classed("entering",true).each(((t,s,i)=>{z(i[s])}));this.enter.attr("class","grid").attr("cursor",!this.suppressEvents?this.cursor:null).each(((t,s,i)=>{z(i[s])})).on("click",!this.suppressEvents?(t,s,i)=>{this.onClickHandler(t,i[s])}:null).on("mouseover",!this.suppressEvents?(t,s,i)=>{this.onHoverHandler(t,i[s])}:null).on("mouseout",!this.suppressEvents?()=>this.onMouseOutHandler():null).attr("opacity",0).attr("y",(t=>{if(this.interpolating&&this.interpolating.y(t.yAccessor)===undefined){let s=this.y(t.yAccessor);s=s+this.y.bandwidth()*(s/this.y(this.y.domain()[0]));return s}else if(this.interpolating){return this.interpolating.y(t.yAccessor)}return this.y(t.yAccessor)})).attr("height",(t=>{if(this.interpolating&&this.interpolating.y(t.yAccessor)===undefined){return 0}else if(this.interpolating){return this.interpolating.y.bandwidth()}return this.y.bandwidth()})).attr("x",(t=>{if(this.interpolating&&this.interpolating.x(t.xAccessor)===undefined){let s=this.x(t.xAccessor);s=s+this.x.bandwidth()*(s/this.x(this.x.domain()[this.x.domain().length-1]));return s}else if(this.interpolating){return this.interpolating.x(t.xAccessor)}return this.x(t.xAccessor)})).attr("width",(t=>{if(this.interpolating&&this.interpolating.x(t.xAccessor)===undefined){return 0}else if(this.interpolating){return this.interpolating.x.bandwidth()}return this.x.bandwidth()})).attr("rx",this.shape==="circle"?this.x.bandwidth():0).attr("ry",this.shape==="circle"?this.y.bandwidth():0);this.update.order();this.enterRowWrappers.order()}updateGeometries(){this.update.interrupt();this.update.transition("opacity").duration(((t,s,i)=>{if(n(i[s]).classed("entering")){n(i[s]).classed("entering",false);return this.duration}return 0})).ease(d).attr("opacity",(t=>et(t,1,this.hoverOpacity,this.hoverHighlight,this.clickHighlight,this.innerInteractionKeys)))}exitGeometries(){this.exit.interrupt();this.exit.transition("exit").duration(this.duration).ease(d).attr("opacity",0).attr("y",((t,s,i)=>{if(this.y(t.yAccessor)===undefined){const t=n(i[s]);let e=+t.attr("y");e=e+ +t.attr("height")*(e/this.y(this.y.domain()[0]));return e}return this.y(t.yAccessor)})).attr("height",(t=>{if(this.y(t.yAccessor)===undefined){return 0}return this.y.bandwidth()})).attr("x",((t,s,i)=>{if(this.x(t.xAccessor)===undefined){const t=n(i[s]);let e=+t.attr("x");e=e+ +t.attr("width")*(e/this.x(this.x.domain()[this.x.domain().length-1]));return e}return this.x(t.xAccessor)})).attr("width",(t=>{if(this.x(t.xAccessor)===undefined){return 0}return this.x.bandwidth()}));this.exitRowWrappers.selectAll(".grid").transition("exit").duration(this.duration).ease(d).attr("opacity",0).attr("y",((t,s,i)=>{const e=n(i[s]);let h=+e.attr("y");h=h+ +e.attr("height")*(h/this.y(this.y.domain()[0]));return h})).attr("height",0).attr("x",((t,s,i)=>{if(this.x(t.xAccessor)===undefined){const t=n(i[s]);let e=+t.attr("x");e=e+ +t.attr("width")*(e/this.x(this.x.domain()[this.x.domain().length-1]));return e}return this.x(t.xAccessor)})).attr("width",(t=>{if(this.x(t.xAccessor)===undefined){return 0}return this.x.bandwidth()}));this.update.transition("accessibilityAfterExit").duration(this.duration).ease(d).call(vt,(()=>{const t=J(this.rootG.node());this.exit.remove();this.exitRowWrappers.remove();this.setChartCountAccessibility();this.setGroupAccessibilityID();this.setGeometryAriaLabels();B({parentGNode:this.rootG.node(),focusDidExist:t})}))}drawGeometries(){this.updateRowWrappers.transition("update").duration(this.duration).ease(d).call(vt,(()=>{this.updateRowWrappers.classed("entering",false)}));const t=this.update.classed("geometryIsMoving",((t,s,i)=>{const e=T(n(i[s]),[{attr:"y",numeric:true,newValue:this.y(t.yAccessor)},{attr:"height",numeric:true,newValue:this.y.bandwidth()},{attr:"x",numeric:true,newValue:this.x(t.xAccessor)},{attr:"width",numeric:true,newValue:this.x.bandwidth()},{attr:"rx",numeric:true,newValue:this.shape==="circle"?this.x.bandwidth():0},{attr:"ry",numeric:true,newValue:this.shape==="circle"?this.y.bandwidth():0}]);return e})).transition("update").duration(this.duration).ease(d).attr("y",(t=>this.y(t.yAccessor))).attr("height",this.y.bandwidth()).attr("x",(t=>this.x(t.xAccessor))).attr("width",this.x.bandwidth()).attr("rx",this.shape==="circle"?this.x.bandwidth():0).attr("ry",this.shape==="circle"?this.y.bandwidth():0);if(this.accessibility.hideTextures||!this.accessibility.showExperimentalTextures){t.attr("fill",(t=>this.heat(t[this.valueAccessor])))}t.call(vt,(()=>{this.update.classed("geometryIsMoving",false);this.updateInteractionState();B({parentGNode:this.rootG.node()});this.transitionEndEvent.emit({chartID:this.chartID})}))}updateInteractionState(){D(this.svg.node());this.update.attr("fill",(t=>this.heat(t[this.valueAccessor]))).attr("opacity",(t=>et(t,1,this.hoverOpacity,this.hoverHighlight,this.clickHighlight,this.innerInteractionKeys))).attr("filter",((t,s,i)=>{if(!this.accessibility.hideStrokes&&!n(i[s]).classed("geometryIsMoving")){const e=this.clickHighlight&&this.clickHighlight.length>0&&ht(t,this.clickHighlight,this.innerInteractionKeys);const h=this.hoverHighlight&&at(t,this.hoverHighlight,this.innerInteractionKeys);const a=!this.accessibility.hideTextures&&this.accessibility.showExperimentalTextures?this.fillColors(t[this.valueAccessor]):this.rawHeat(t[this.valueAccessor]);const r=!this.accessibility.hideTextures&&this.accessibility.showExperimentalTextures?this.strokeColors(t[this.valueAccessor]):undefined;const o=e?"click":h&&!n(i[s]).classed("geometryIsMoving")?"hover":"rest";if(o==="hover"){S({inputElement:i[s],id:this.chartID,key:t[this.xAccessor]+t[this.yAccessor],strokeWidth:this.hoverStyle.strokeWidth,fill:a,strokeOverride:r})}return this.strokes[o+a]}return null}));B({parentGNode:this.rootG.node()});this.updateLabels.attr("fill",this.textTreatmentHandler)}setLabelOpacity(){this.processLabelOpacity(this.updateLabels)}processLabelOpacity(t,s){const i=this.dataLabel.visible?1:0;const e={width:this.x.bandwidth(),height:this.y.bandwidth()};const h=t=>{let s=this.dataLabel.labelAccessor?t[this.dataLabel.labelAccessor]:t.valueAccessor;s=s instanceof Date?ut({date:s,format:this.dataLabel.format,offsetTimezone:true}):ct(s,this.dataLabel.format);const h=this.accessibility.showSmallLabels||w({text:s,dimensions:e,fontSize:14});return h?et(t,i,this.hoverOpacity,this.hoverHighlight,this.clickHighlight,this.innerInteractionKeys)<1?0:1:0};if(s){t.attr("opacity",h)}else{t.each(((t,s,i)=>{if(!n(i[s]).classed("entering")){n(i[s]).attr("opacity",(()=>h(t)))}}))}}setSelectedClass(){this.update.classed("highlight",((t,s,i)=>{let e=et(t,true,false,"",this.clickHighlight,this.innerInteractionKeys);e=this.clickHighlight&&this.clickHighlight.length?e:false;const h=this.accessibility.elementsAreInterface;Q(i[s],e,h);return e}))}updateCursor(){this.update.attr("cursor",!this.suppressEvents?this.cursor:null);this.updateLabels.attr("cursor",!this.suppressEvents?this.cursor:null)}bindInteractivity(){this.update.on("click",!this.suppressEvents?(t,s,i)=>{this.onClickHandler(t,i[s])}:null).on("mouseover",!this.suppressEvents?(t,s,i)=>{this.onHoverHandler(t,i[s])}:null).on("mouseout",!this.suppressEvents?()=>this.onMouseOutHandler():null);this.updateLabels.on("click",!this.suppressEvents?(t,s,i)=>this.onClickHandler(t,i[s]):null).on("mouseover",!this.suppressEvents?(t,s,i)=>this.onHoverHandler(t,i[s]):null).on("mouseout",!this.suppressEvents?()=>this.onMouseOutHandler():null)}enterDataLabels(){this.enteringLabelGroups.attr("class","heat-map-label-wrapper");this.enterLabels.attr("class","heat-map-dataLabel entering").attr("opacity",0).attr("fill",this.textTreatmentHandler).attr("cursor",!this.suppressEvents?this.cursor:null).on("click",!this.suppressEvents?(t,s,i)=>this.onClickHandler(t,i[s]):null).on("mouseover",!this.suppressEvents?(t,s,i)=>this.onHoverHandler(t,i[s]):null).on("mouseout",!this.suppressEvents?()=>this.onMouseOutHandler():null);bt({root:this.enterLabels,xScale:this.x,yScale:this.y,ordinalAccessor:"xAccessor",valueAccessor:"yAccessor",chartType:"heat-map"})}updateDataLabels(){const t=this.updateLabels.transition("opacity").ease(d).duration(((t,s,i)=>{if(n(i[s]).classed("entering")){return this.duration/2}return 0})).delay(((t,s,i)=>{if(n(i[s]).classed("entering")){return this.duration/2}return 0}));this.processLabelOpacity(t,true);t.call(vt,(()=>{this.updateLabels.classed("entering",false)}))}exitDataLabels(){this.exitLabels.transition("exit").ease(d).duration(this.duration/2).attr("opacity",0).remove();this.exitingLabelGroups.selectAll("text").transition("exit").ease(d).duration(this.duration/2).attr("opacity",0).call(vt,(()=>{this.exitingLabelGroups.remove()}))}drawDataLabels(){this.updateLabels.attr("fill",this.textTreatmentHandler).text((t=>{const s=this.dataLabel.labelAccessor?t[this.dataLabel.labelAccessor]:t.valueAccessor;return s instanceof Date?ut({date:s,format:this.dataLabel.format,offsetTimezone:true}):ct(s,this.dataLabel.format)}));const t=this.updateLabels.transition("update").ease(d).duration(this.duration);bt({root:t,xScale:this.x,yScale:this.y,ordinalAccessor:"xAccessor",valueAccessor:"yAccessor",chartType:"heat-map"})}drawLegendElements(){nt({root:this.legendG,uniqueID:this.chartID,width:this.innerPaddedWidth,height:this.margin.bottom+60,colorArr:this.legend&&this.legend.type!=="gradient"?this.colorArr:this.preparedColors,baseColorArr:!(this.colorPalette&&this.colorPalette.includes("diverging"))?[this.preparedColors[this.preparedColors.length-1]]:this.strokeColors.range(),hideStrokes:this.accessibility.hideStrokes,scale:this.heat,steps:this.colorSteps,margin:this.margin,padding:this.padding,duration:this.duration,type:this.legend.type,fontSize:12,label:this.legend.labels,format:this.legend.format,hide:!this.legend.visible})}drawAnnotations(){st({source:this.rootG.node(),data:this.annotations,xScale:this.x,xAccessor:this.xAccessor,yScale:this.y,yAccessor:this.yAccessor})}setAnnotationAccessibility(){U(this.getLanguageString(),this.heatMapEl,this.annotations,undefined)}setTagLevels(){this.topLevel=I(this.highestHeadingLevel);this.bottomLevel=I(this.highestHeadingLevel,3)}setChartDescriptionWrapper(){O({language:this.getLanguageString(),rootEle:this.heatMapEl,title:this.accessibility.title||this.mainTitle,chartTag:"heat-map",uniqueID:this.chartID,highestHeadingLevel:this.highestHeadingLevel,redraw:this.shouldRedrawWrapper,disableKeyNav:this.suppressEvents&&this.accessibility.elementsAreInterface===false&&this.accessibility.keyboardNavConfig&&this.accessibility.keyboardNavConfig.disabled,hideDataTable:this.accessibility.hideDataTableButton});this.shouldRedrawWrapper=false}setParentSVGAccessibility(){K({chartTag:"heat-map",language:this.getLanguageString(),node:this.svg.node(),title:this.accessibility.title||this.mainTitle,description:this.subTitle,uniqueID:this.chartID,geomType:"cell",includeKeyNames:this.accessibility.includeDataKeyNames,dataKeys:xt(this,it,"heat-map"),dataKeyNames:this.dataKeyNames,groupAccessor:this.yAccessor,groupName:"row",disableKeyNav:this.suppressEvents&&this.accessibility.elementsAreInterface===false&&this.accessibility.keyboardNavConfig&&this.accessibility.keyboardNavConfig.disabled})}setGeometryAccessibilityAttributes(){this.update.each(((t,s,i)=>{z(i[s])}))}setGeometryAriaLabels(){const t=xt(this,it,"heat-map");this.update.each(((s,i,e)=>{N({chartTag:"heat-map",language:this.getLanguageString(),node:e[i],geomType:"cell",includeKeyNames:this.accessibility.includeDataKeyNames,dataKeys:t,dataKeyNames:this.dataKeyNames,groupName:"row",uniqueID:this.chartID,disableKeyNav:this.suppressEvents&&this.accessibility.elementsAreInterface===false&&this.accessibility.keyboardNavConfig&&this.accessibility.keyboardNavConfig.disabled});j({node:e[i],uniqueID:this.chartID})}))}setGroupAccessibilityID(){this.updateRowWrappers.each(((t,s,i)=>{j({node:i[s],uniqueID:this.chartID})}))}setChartAccessibilityTitle(){P(this.getLanguageString(),this.heatMapEl,this.accessibility.title||this.mainTitle)}setChartAccessibilitySubtitle(){G(this.getLanguageString(),this.heatMapEl,this.subTitle)}setChartAccessibilityLongDescription(){q(this.getLanguageString(),this.heatMapEl,this.accessibility.longDescription)}setChartAccessibilityExecutiveSummary(){V(this.getLanguageString(),this.heatMapEl,this.accessibility.executiveSummary)}setChartAccessibilityPurpose(){M(this.getLanguageString(),this.heatMapEl,this.accessibility.purpose)}setChartAccessibilityContext(){$(this.getLanguageString(),this.heatMapEl,this.accessibility.contextExplanation)}setChartAccessibilityStatisticalNotes(){F(this.getLanguageString(),this.heatMapEl,this.accessibility.statisticalNotes)}setChartCountAccessibility(){R({rootEle:this.heatMapEl,parentGNode:this.map.node(),chartTag:"heat-map",geomType:"cell",groupName:"row"})}setChartAccessibilityStructureNotes(){_(this.getLanguageString(),this.heatMapEl,this.accessibility.structureNotes)}onChangeHandler(){if(this.accessibility&&typeof this.accessibility.onChangeFunc==="function"){const t={updated:this.updated,added:this.enterSize,removed:this.exitSize};this.accessibility.onChangeFunc(t)}this.updated=false;this.enterSize=0;this.exitSize=0}onClickHandler(t,s){this.clickEvent.emit({data:t,target:s})}onHoverHandler(t,s){yt(this.chartID,true);this.hoverEvent.emit({data:t,target:s});if(this.showTooltip){this.eventsTooltip({data:t,evt:l,isToShow:true})}}onMouseOutHandler(){yt(this.chartID,false);this.mouseOutEvent.emit();if(this.showTooltip){this.eventsTooltip({isToShow:false})}}setTooltipInitialStyle(){gt(this.tooltipG)}eventsTooltip({data:t,evt:s,isToShow:i}){lt({root:this.tooltipG,data:t,event:s,isToShow:i,tooltipLabel:this.tooltipLabel,xAxis:this.xAxis,yAxis:this.yAxis,dataLabel:this.dataLabel,dataKeyNames:this.dataKeyNames,valueAccessor:this.valueAccessor,xAccessor:this.xAccessor,yAccessor:this.yAccessor,chartType:"heat-map"})}render(){this.drawStartEvent.emit({chartID:this.chartID});this.init();if(this.shouldSetLocalizationConfig){this.setLocalizationConfig();this.shouldSetLocalizationConfig=false}if(this.shouldSetTagLevels){this.setTagLevels();this.shouldSetTagLevels=false}if(this.shouldUpdateData){this.prepareData();this.shouldUpdateData=false}if(this.shouldSetDimensions){this.setDimensions();this.shouldSetDimensions=false}if(this.shouldSetColors){this.setColors();this.shouldSetColors=false}if(this.shouldUpdateScales){this.prepareScales();this.shouldUpdateScales=false}if(this.shouldFormatClickHighlight){this.formatClickHighlight();this.shouldFormatClickHighlight=false}if(this.shouldFormatHoverHighlight){this.formatHoverHighlight();this.shouldFormatHoverHighlight=false}if(this.shouldValidateInteractionKeys){this.validateInteractionKeys();this.shouldValidateInteractionKeys=false}if(this.shouldUpdateTableData){this.setTableData();this.shouldUpdateTableData=false}if(this.shouldValidate){this.shouldValidateAccessibilityProps();this.shouldValidateLocalizationProps();this.shouldValidate=false}return i("div",{key:"240f7f676fe22edbefe4d6cea36692509f86fa1f",class:`o-layout`},i("div",{key:"879439bf0cdf6b0159cef9a40c2dbd8fe2f3d37d",class:"o-layout--chart"},i(this.topLevel,{key:"e4e8a187ff9525f42282c72f3778f20c99a1210f",class:"heat-main-title vcl-main-title"},this.mainTitle),i(this.bottomLevel,{key:"31d5f0969d472b9924c24880e2a20a34c59121cc",class:"visa-ui-text--instructions heat-sub-title vcl-sub-title"}),i("div",{key:"f9ef146256cfac4b11aedc9bc7fd8c0328c47de5",class:"heat-map-legend vcl-legend",style:{display:this.legend.visible?"block":"none"}}),i("keyboard-instructions",{key:"228a18ec888929e62c8442f45e04228323094d77",uniqueID:this.chartID,geomType:"cell",groupName:"row",language:this.getLanguageString(),chartTag:"heat-map",width:this.width-(this.margin?this.margin.right||0:0),isInteractive:this.accessibility.elementsAreInterface,hasCousinNavigation:true,disabled:this.suppressEvents&&this.accessibility.elementsAreInterface===false&&this.accessibility.keyboardNavConfig&&this.accessibility.keyboardNavConfig.disabled}),i("div",{key:"cca19b1a69d22fafca24c6370ec40366b842cad3",class:"visa-viz-d3-heat-map-container"}),i("div",{key:"0154056687d6429bcab1ed16d174a374b2a789d5",class:"heat-map-tooltip vcl-tooltip",style:{display:this.showTooltip?"block":"none"}}),i("data-table",{key:"0946e20c50c3f7f0395ceb159720b8302a9561c9",uniqueID:this.chartID,isCompact:true,language:this.getLanguageString(),tableColumns:this.tableColumns,data:this.tableData,dataKeyNames:this.dataKeyNames,padding:this.padding,margin:this.margin,hideDataTable:this.accessibility.hideDataTableButton,unitTest:this.unitTest})))}init(){const t=Object.keys(m);let s=0;const i={strokeWidth:{exception:0},showTooltip:{exception:false},mainTitle:{exception:""},subTitle:{exception:""},wrapLabel:{exception:false},hoverOpacity:{exception:0}};for(s=0;s<t.length;s++){const e=!i[t[s]]?false:this[t[s]]===i[t[s]].exception;this[t[s]]=this[t[s]]||e?this[t[s]]:m[t[s]]}}get heatMapEl(){return e(this)}static get watchers(){return{data:["dataWatcher"],uniqueID:["idWatcher"],highestHeadingLevel:["headingWatcher"],mainTitle:["titleWatcher"],subTitle:["subtitleWatcher"],height:["layoutWatcher"],width:["layoutWatcher"],padding:["layoutWatcher"],margin:["layoutWatcher"],xAccessor:["xAccessorWatcher"],yAccessor:["yAccessorWatcher"],valueAccessor:["groupAccessorWatcher"],xKeyOrder:["xKeyOrderWatcher"],yKeyOrder:["yKeyOrderWatcher"],xAxis:["xAxisWatcher"],yAxis:["yAxisWatcher"],wrapLabel:["wrapLabelWatcher"],hideAxisPath:["hideAxisPathWatcher"],colorPalette:["colorsWatcher"],colors:["colorsWatcher"],colorSteps:["colorsWatcher"],hoverStyle:["hoverStyleWatcher"],clickStyle:["clickStyleWatcher"],shape:["shapeWatcher"],cursor:["cursorWatcher"],strokeWidth:["strokeWidthWatcher"],hoverOpacity:["hoverOpacityWatcher"],dataLabel:["labelWatcher"],showTooltip:["showTooltipWatcher"],tooltipLabel:["tooltipLabelWatcher"],legend:["legendWatcher"],suppressEvents:["suppressWatcher"],annotations:["annotationsWatcher"],accessibility:["accessibilityWatcher"],localization:["localizationWatcher"],maxValueOverride:["valueOverrideWatcher"],minValueOverride:["valueOverrideWatcher"],clickHighlight:["clickWatcher"],hoverHighlight:["hoverWatcher"],interactionKeys:["interactionWatcher"],dataKeyNames:["dataKeyNamesWatcher"],unitTest:["unitTestWatcher"]}}};window["VisaChartsLibOSSLicenses"]=dt();Tt.style=y;export{Tt as heat_map};
//# sourceMappingURL=p-c5d4d78a.entry.js.map