/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.math.linearfilters;

import java.util.Arrays;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.api.math.linearfilters.AsymmetricFilterOption;
import jdplus.toolkit.base.api.math.linearfilters.FilterSpec;
import jdplus.toolkit.base.api.math.linearfilters.KernelOption;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class LocalPolynomialFilterSpec
implements FilterSpec {
    public static final double DEF_SLOPE = 2.0 / (Math.sqrt(Math.PI) * 3.5);
    public static final LocalPolynomialFilterSpec DEF_TREND_SPEC = LocalPolynomialFilterSpec.builder().build();
    public static final LocalPolynomialFilterSpec DEF_SEAS_SPEC = LocalPolynomialFilterSpec.builder().filterHorizon(2).polynomialDegree(0).asymmetricPolynomialDegree(0).linearModelCoefficients(Doubles.EMPTYARRAY).build();
    private final int filterHorizon;
    private final KernelOption kernel;
    private final int polynomialDegree;
    private final AsymmetricFilterOption asymmetricFilters;
    private final int asymmetricPolynomialDegree;
    private final double[] leftLinearModelCoefficients;
    private final double[] rightLinearModelCoefficients;
    private final double timelinessWeight;
    private final double passBand;

    public static LocalPolynomialFilterSpec defaultSeasonalSpec(int horizon, KernelOption kernel) {
        return LocalPolynomialFilterSpec.builder().filterHorizon(horizon).kernel(kernel).polynomialDegree(0).asymmetricPolynomialDegree(0).linearModelCoefficients(Doubles.EMPTYARRAY).build();
    }

    public static Builder builder() {
        return new Builder().filterHorizon(6).kernel(KernelOption.Henderson).polynomialDegree(2).asymmetricFilters(AsymmetricFilterOption.MMSRE).asymmetricPolynomialDegree(0).linearModelCoefficients(DEF_SLOPE).timelinessWeight(0.0).passBand(0.39269908169872414);
    }

    public boolean isSymmetric() {
        return this.asymmetricFilters == AsymmetricFilterOption.CutAndNormalize || this.asymmetricFilters == AsymmetricFilterOption.Direct || Arrays.equals(this.leftLinearModelCoefficients, this.rightLinearModelCoefficients);
    }

    @Generated
    LocalPolynomialFilterSpec(int filterHorizon, KernelOption kernel, int polynomialDegree, AsymmetricFilterOption asymmetricFilters, int asymmetricPolynomialDegree, double[] leftLinearModelCoefficients, double[] rightLinearModelCoefficients, double timelinessWeight, double passBand) {
        this.filterHorizon = filterHorizon;
        this.kernel = kernel;
        this.polynomialDegree = polynomialDegree;
        this.asymmetricFilters = asymmetricFilters;
        this.asymmetricPolynomialDegree = asymmetricPolynomialDegree;
        this.leftLinearModelCoefficients = leftLinearModelCoefficients;
        this.rightLinearModelCoefficients = rightLinearModelCoefficients;
        this.timelinessWeight = timelinessWeight;
        this.passBand = passBand;
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().filterHorizon(this.filterHorizon).kernel(this.kernel).polynomialDegree(this.polynomialDegree).asymmetricFilters(this.asymmetricFilters).asymmetricPolynomialDegree(this.asymmetricPolynomialDegree).leftLinearModelCoefficients(this.leftLinearModelCoefficients).rightLinearModelCoefficients(this.rightLinearModelCoefficients).timelinessWeight(this.timelinessWeight).passBand(this.passBand);
    }

    @Generated
    public int getFilterHorizon() {
        return this.filterHorizon;
    }

    @Generated
    public KernelOption getKernel() {
        return this.kernel;
    }

    @Generated
    public int getPolynomialDegree() {
        return this.polynomialDegree;
    }

    @Generated
    public AsymmetricFilterOption getAsymmetricFilters() {
        return this.asymmetricFilters;
    }

    @Generated
    public int getAsymmetricPolynomialDegree() {
        return this.asymmetricPolynomialDegree;
    }

    @Generated
    public double[] getLeftLinearModelCoefficients() {
        return this.leftLinearModelCoefficients;
    }

    @Generated
    public double[] getRightLinearModelCoefficients() {
        return this.rightLinearModelCoefficients;
    }

    @Generated
    public double getTimelinessWeight() {
        return this.timelinessWeight;
    }

    @Generated
    public double getPassBand() {
        return this.passBand;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalPolynomialFilterSpec)) {
            return false;
        }
        LocalPolynomialFilterSpec other = (LocalPolynomialFilterSpec)o;
        if (this.getFilterHorizon() != other.getFilterHorizon()) {
            return false;
        }
        if (this.getPolynomialDegree() != other.getPolynomialDegree()) {
            return false;
        }
        if (this.getAsymmetricPolynomialDegree() != other.getAsymmetricPolynomialDegree()) {
            return false;
        }
        if (Double.compare(this.getTimelinessWeight(), other.getTimelinessWeight()) != 0) {
            return false;
        }
        if (Double.compare(this.getPassBand(), other.getPassBand()) != 0) {
            return false;
        }
        KernelOption this$kernel = this.getKernel();
        KernelOption other$kernel = other.getKernel();
        if (this$kernel == null ? other$kernel != null : !((Object)((Object)this$kernel)).equals((Object)other$kernel)) {
            return false;
        }
        AsymmetricFilterOption this$asymmetricFilters = this.getAsymmetricFilters();
        AsymmetricFilterOption other$asymmetricFilters = other.getAsymmetricFilters();
        if (this$asymmetricFilters == null ? other$asymmetricFilters != null : !((Object)((Object)this$asymmetricFilters)).equals((Object)other$asymmetricFilters)) {
            return false;
        }
        if (!Arrays.equals(this.getLeftLinearModelCoefficients(), other.getLeftLinearModelCoefficients())) {
            return false;
        }
        return Arrays.equals(this.getRightLinearModelCoefficients(), other.getRightLinearModelCoefficients());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFilterHorizon();
        result = result * 59 + this.getPolynomialDegree();
        result = result * 59 + this.getAsymmetricPolynomialDegree();
        long $timelinessWeight = Double.doubleToLongBits(this.getTimelinessWeight());
        result = result * 59 + (int)($timelinessWeight >>> 32 ^ $timelinessWeight);
        long $passBand = Double.doubleToLongBits(this.getPassBand());
        result = result * 59 + (int)($passBand >>> 32 ^ $passBand);
        KernelOption $kernel = this.getKernel();
        result = result * 59 + ($kernel == null ? 43 : ((Object)((Object)$kernel)).hashCode());
        AsymmetricFilterOption $asymmetricFilters = this.getAsymmetricFilters();
        result = result * 59 + ($asymmetricFilters == null ? 43 : ((Object)((Object)$asymmetricFilters)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getLeftLinearModelCoefficients());
        result = result * 59 + Arrays.hashCode(this.getRightLinearModelCoefficients());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "LocalPolynomialFilterSpec(filterHorizon=" + this.getFilterHorizon() + ", kernel=" + String.valueOf((Object)this.getKernel()) + ", polynomialDegree=" + this.getPolynomialDegree() + ", asymmetricFilters=" + String.valueOf((Object)this.getAsymmetricFilters()) + ", asymmetricPolynomialDegree=" + this.getAsymmetricPolynomialDegree() + ", leftLinearModelCoefficients=" + Arrays.toString(this.getLeftLinearModelCoefficients()) + ", rightLinearModelCoefficients=" + Arrays.toString(this.getRightLinearModelCoefficients()) + ", timelinessWeight=" + this.getTimelinessWeight() + ", passBand=" + this.getPassBand() + ")";
    }

    public static class Builder {
        @Generated
        private int filterHorizon;
        @Generated
        private KernelOption kernel;
        @Generated
        private int polynomialDegree;
        @Generated
        private AsymmetricFilterOption asymmetricFilters;
        @Generated
        private int asymmetricPolynomialDegree;
        @Generated
        private double[] leftLinearModelCoefficients;
        @Generated
        private double[] rightLinearModelCoefficients;
        @Generated
        private double timelinessWeight;
        @Generated
        private double passBand;

        public Builder linearModelCoefficients(double ... coefs) {
            this.leftLinearModelCoefficients = coefs;
            this.rightLinearModelCoefficients = coefs;
            return this;
        }

        public Builder leftLinearModelCoefficients(double ... coefs) {
            this.leftLinearModelCoefficients = coefs;
            return this;
        }

        public Builder rightLinearModelCoefficients(double ... coefs) {
            this.rightLinearModelCoefficients = coefs;
            return this;
        }

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder filterHorizon(int filterHorizon) {
            this.filterHorizon = filterHorizon;
            return this;
        }

        @Generated
        public @NonNull Builder kernel(KernelOption kernel) {
            this.kernel = kernel;
            return this;
        }

        @Generated
        public @NonNull Builder polynomialDegree(int polynomialDegree) {
            this.polynomialDegree = polynomialDegree;
            return this;
        }

        @Generated
        public @NonNull Builder asymmetricFilters(AsymmetricFilterOption asymmetricFilters) {
            this.asymmetricFilters = asymmetricFilters;
            return this;
        }

        @Generated
        public @NonNull Builder asymmetricPolynomialDegree(int asymmetricPolynomialDegree) {
            this.asymmetricPolynomialDegree = asymmetricPolynomialDegree;
            return this;
        }

        @Generated
        public @NonNull Builder timelinessWeight(double timelinessWeight) {
            this.timelinessWeight = timelinessWeight;
            return this;
        }

        @Generated
        public @NonNull Builder passBand(double passBand) {
            this.passBand = passBand;
            return this;
        }

        @Generated
        public @NonNull LocalPolynomialFilterSpec build() {
            return new LocalPolynomialFilterSpec(this.filterHorizon, this.kernel, this.polynomialDegree, this.asymmetricFilters, this.asymmetricPolynomialDegree, this.leftLinearModelCoefficients, this.rightLinearModelCoefficients, this.timelinessWeight, this.passBand);
        }

        @Generated
        public @NonNull String toString() {
            return "LocalPolynomialFilterSpec.Builder(filterHorizon=" + this.filterHorizon + ", kernel=" + String.valueOf((Object)this.kernel) + ", polynomialDegree=" + this.polynomialDegree + ", asymmetricFilters=" + String.valueOf((Object)this.asymmetricFilters) + ", asymmetricPolynomialDegree=" + this.asymmetricPolynomialDegree + ", leftLinearModelCoefficients=" + Arrays.toString(this.leftLinearModelCoefficients) + ", rightLinearModelCoefficients=" + Arrays.toString(this.rightLinearModelCoefficients) + ", timelinessWeight=" + this.timelinessWeight + ", passBand=" + this.passBand + ")";
        }
    }
}

