/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.likelihood;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.math.functions.IParametersDomain;
import jdplus.toolkit.base.core.math.functions.IParametricMapping;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.likelihood.DiffuseConcentratedLikelihoodFunctionPoint;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfBuilder;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.stats.likelihood.DiffuseConcentratedLikelihood;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodFunction;

public class DiffuseConcentratedLikelihoodFunction<S, F extends ISsf>
implements LikelihoodFunction<DiffuseConcentratedLikelihood> {
    private final IParametricMapping<S> mapping;
    private final ISsfBuilder<S, F> builder;
    private final ISsfData data;
    private final boolean missing;
    private final FastMatrix X;
    private final int diffuseX;
    private final boolean ml;
    private final boolean log;
    private final boolean fast;
    private final boolean mt;
    private final boolean sym;
    private final boolean scaling;

    public static <S, F extends ISsf> Builder builder(ISsfData data, IParametricMapping<S> mapping, ISsfBuilder<S, F> builder) {
        return new Builder<S, F>(data, mapping, builder);
    }

    private DiffuseConcentratedLikelihoodFunction(ISsfData data, FastMatrix X, int diffuseX, IParametricMapping<S> mapper, ISsfBuilder<S, F> builder, boolean ml, boolean log, boolean fast, boolean mt, boolean sym, boolean scaling) {
        this.data = data;
        this.mapping = mapper;
        this.builder = builder;
        this.X = X;
        this.diffuseX = diffuseX;
        this.missing = data.hasMissingValues();
        this.ml = ml;
        this.fast = fast;
        this.log = log;
        this.mt = mt;
        this.sym = sym;
        this.scaling = scaling;
    }

    public IParametricMapping<S> getMapping() {
        return this.mapping;
    }

    public boolean isMaximumLikelihood() {
        return this.ml;
    }

    public boolean isLog() {
        return this.log;
    }

    public boolean isFast() {
        return this.fast;
    }

    public boolean isScalingFactor() {
        return this.scaling;
    }

    @Override
    public DiffuseConcentratedLikelihoodFunctionPoint<S, F> evaluate(DoubleSeq parameters) {
        return new DiffuseConcentratedLikelihoodFunctionPoint(this, parameters);
    }

    @Override
    public IParametersDomain getDomain() {
        return this.mapping;
    }

    @Override
    public DiffuseConcentratedLikelihoodFunctionPoint<S, F> ssqEvaluate(DoubleSeq parameters) {
        return new DiffuseConcentratedLikelihoodFunctionPoint(this, parameters);
    }

    public ISsfBuilder<S, F> getBuilder() {
        return this.builder;
    }

    public ISsfData getData() {
        return this.data;
    }

    public boolean isMissing() {
        return this.missing;
    }

    public FastMatrix getX() {
        return this.X;
    }

    public int getDiffuseX() {
        return this.diffuseX;
    }

    public boolean isMl() {
        return this.ml;
    }

    public boolean isMultiThreaded() {
        return this.mt;
    }

    public boolean isSymmetric() {
        return this.sym;
    }

    public static class Builder<S, F extends ISsf> {
        private final IParametricMapping<S> mapping;
        private final ISsfBuilder<S, F> builder;
        private final ISsfData data;
        private FastMatrix X;
        private int diffuseX;
        private boolean ml = true;
        private boolean log = false;
        private boolean fast = false;
        private boolean mt = false;
        private boolean sym = false;
        private boolean scalingFactor = true;

        private Builder(ISsfData data, IParametricMapping<S> mapping, ISsfBuilder<S, F> builder) {
            this.data = data;
            this.builder = builder;
            this.mapping = mapping;
        }

        public Builder regression(FastMatrix X, int diffuseX) {
            this.X = X;
            this.diffuseX = diffuseX;
            return this;
        }

        public Builder useParallelProcessing(boolean mt) {
            this.mt = mt;
            return this;
        }

        public Builder useMaximumLikelihood(boolean ml) {
            this.ml = ml;
            return this;
        }

        public Builder useLog(boolean log) {
            this.log = log;
            return this;
        }

        public Builder useFastAlgorithm(boolean fast) {
            this.fast = fast;
            return this;
        }

        public Builder useSymmetricNumericalDerivatives(boolean sym) {
            this.sym = sym;
            return this;
        }

        public Builder useScalingFactor(boolean scalingFactor) {
            this.scalingFactor = scalingFactor;
            if (!scalingFactor) {
                this.log = true;
            }
            return this;
        }

        public DiffuseConcentratedLikelihoodFunction<S, F> build() {
            return new DiffuseConcentratedLikelihoodFunction<S, F>(this.data, this.X, this.diffuseX, this.mapping, this.builder, this.ml, this.log, this.fast, this.mt, this.sym, this.scalingFactor);
        }
    }
}

