/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.BetaDist;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.util.Num;
import umontreal.iro.lecuyer.util.RootFinder;

public class BetaSymmetricalDist
extends BetaDist {
    private static final double PI_2 = 1.5707963267948966;
    private static final int MAXI = 11;
    private static final int MAXIB = 50;
    private static final int MAXJ = 2000;
    private static final double EPSSINGLE = 1.0E-5;
    private static final double EPSBETA = 1.0E-10;
    private static final double SQPI_2 = 0.886226925452758;
    private static final double LOG_SQPI_2 = -0.1207822376352453;
    private static final double ALIM1 = 100000.0;
    private static final double LOG2 = 0.6931471805599453;
    private static final double LOG4 = 1.3862943611198906;
    private static final double INV2PI = 0.6366197723675813;
    private double Ceta;
    private double logCeta;

    public BetaSymmetricalDist(double alpha) {
        super(alpha, alpha);
        this.setParams(alpha, 14);
    }

    public BetaSymmetricalDist(double alpha, int d) {
        super(alpha, alpha, d);
        this.setParams(alpha, d);
    }

    public double cdf(double x) {
        return BetaSymmetricalDist.calcCdf(this.alpha, x, this.decPrec, this.logFactor, this.logBeta, this.logCeta, this.Ceta);
    }

    public double barF(double x) {
        return BetaSymmetricalDist.calcCdf(this.alpha, 1.0 - x, this.decPrec, this.logFactor, this.logBeta, this.logCeta, this.Ceta);
    }

    public double inverseF(double u) {
        return BetaSymmetricalDist.calcInverseF(this.alpha, u, this.decPrec, this.logFactor, this.logBeta, this.logCeta, this.Ceta);
    }

    public static double density(double alpha, double x) {
        return BetaSymmetricalDist.density(alpha, alpha, 0.0, 1.0, x);
    }

    public static double cdf(double alpha, int d, double x) {
        return BetaSymmetricalDist.calcCdf(alpha, x, d, Double.MIN_NORMAL, 0.0, 0.0, 0.0);
    }

    public static double barF(double alpha, int d, double x) {
        return BetaSymmetricalDist.cdf(alpha, d, 1.0 - x);
    }

    public static double inverseF(double alpha, double u) {
        return BetaSymmetricalDist.calcInverseF(alpha, u, 14, Double.MIN_NORMAL, 0.0, 0.0, 0.0);
    }

    private static double series1(double alpha, double x, double epsilon) {
        double term;
        double poc = 1.0;
        double sum = 1.0 / alpha;
        int j = 1;
        while ((term = (poc *= x * ((double)j - alpha) / (double)j) / ((double)j + alpha)) > (sum += term) * epsilon && ++j < 2000) {
        }
        return sum * Math.pow(x, alpha);
    }

    private static double series2(double alpha, double y, double epsilon) {
        double term;
        double z = 4.0 * y * y;
        double sum = 1.0;
        double poc = 1.0;
        int j = 1;
        while ((term = (poc *= z * ((double)j - alpha) / (double)j) / (double)(2 * j + 1)) > (sum += term) * epsilon && ++j < 2000) {
        }
        return sum * y;
    }

    private static double series3(double alpha, double x, double epsilon) {
        double z = -x / (1.0 - x);
        double term = 1.0;
        double sum = 1.0;
        int j = 1;
        while (Math.abs(term) > (sum += (term *= z * ((double)j - alpha) / ((double)j + alpha))) * epsilon && ++j < 2000) {
        }
        return sum * x;
    }

    private static double series4(double alpha, double y, double epsilon) {
        double z = 4.0 * y * y;
        double sum = 1.0;
        double term = 1.0;
        int j = 1;
        while (term > (sum += (term *= z * ((double)j + alpha - 0.5) / (0.5 + (double)j))) * epsilon && ++j < 2000) {
        }
        return sum * y;
    }

    private static double Peizer(double alpha, double x) {
        double y = 1.0 - x;
        double z = Math.sqrt((1.0 - y * BetaDist.beta_g(2.0 * x) - x * BetaDist.beta_g(2.0 * y)) / ((2.0 * alpha - 0.8333333333333334) * x * y)) * (2.0 * x - 1.0) * (alpha - 0.3333333333333333 + 0.025 / alpha);
        return NormalDist.cdf01(z);
    }

    private static double inverse1(double alpha, double bu, int d) {
        double EPSILON = EPSARRAY[d];
        double x = Math.pow(bu * alpha, 1.0 / alpha);
        double term = alpha * (1.0 - alpha) * x / (1.0 + alpha);
        if (term < EPSILON) {
            return x;
        }
        x = bu * alpha / (1.0 + term);
        double xnew = Math.pow(x, 1.0 / alpha);
        int i = 0;
        do {
            ++i;
            x = xnew;
            double poc = 1.0;
            double sum = 1.0 / alpha;
            int j = 1;
            while ((term = (poc *= x * ((double)j - alpha) / (double)j) / ((double)j + alpha)) > (sum += term) * EPSILON && ++j < 2000) {
            }
            term = ((sum *= Math.pow(x, alpha)) - bu) * Math.pow(x * (1.0 - x), 1.0 - alpha);
            xnew = x - term;
        } while (Math.abs(term) > EPSILON && i <= 11);
        return xnew;
    }

    private static double inverse2(double alpha, double w, int d) {
        double z;
        double y;
        double term = (1.0 - alpha) * w * w * 4.0 / 3.0;
        double EPSILON = EPSARRAY[d];
        if (term < EPSILON) {
            return 0.5 - w;
        }
        double ynew = w / (1.0 + term);
        int i = 0;
        do {
            ++i;
            y = ynew;
            z = 4.0 * y * y;
            double sum = 1.0;
            double poc = 1.0;
            int j = 1;
            while ((term = (poc *= z * ((double)j - alpha) / (double)j) / (double)(2 * j + 1)) > (sum += term) * EPSILON && ++j < 2000) {
            }
        } while (Math.abs((ynew = y - ((sum *= y) - w) * Math.pow(1.0 - z, 1.0 - alpha)) - y) > EPSILON && i <= 11);
        return 0.5 - ynew;
    }

    private static double bisect(double alpha, double logBua, double a, double b, int d) {
        double xprev;
        double EPSILON = EPSARRAY[d];
        if (a >= 0.5 || a > b) {
            a = 0.0;
            b = 0.5;
        }
        double x = 0.5 * (a + b);
        int i = 0;
        do {
            ++i;
            double z = -x / (1.0 - x);
            double term = 1.0;
            double sum = 1.0;
            int j = 1;
            while (Math.abs(term / (sum += (term *= z * ((double)j - alpha) / ((double)j + alpha)))) > EPSILON && ++j < 2000) {
            }
            sum *= x;
            term = Math.log(x * (1.0 - x));
            z = logBua - (alpha - 1.0) * term;
            if (z > Math.log(sum)) {
                a = x;
                continue;
            }
            b = x;
        } while (Math.abs((xprev = x) - (x = 0.5 * (a + b))) > EPSILON && i < 50);
        return x;
    }

    private static double inverse3(double alpha, double logBua, int d) {
        double sum = 0.0;
        double eps = 1.0E-5;
        double EPSILON = EPSARRAY[d];
        double X0 = 0.497;
        double w = logBua / alpha;
        double x = Math.exp(w);
        double term = (Math.log1p(-x) + logBua) / alpha;
        double z = Math.exp(term);
        double xnew = z >= 0.25 ? 0.497 : (z > 1.0E-6 ? (1.0 - Math.sqrt(1.0 - 4.0 * z)) / 2.0 : z);
        int i = 0;
        do {
            ++i;
            if (xnew >= 0.5) {
                xnew = 0.497;
            }
            if (Math.abs(w = logBua - (alpha - 1.0) * (sum = Math.log((x = xnew) * (1.0 - x)))) >= 709.782712893384) {
                xnew = 0.497;
                continue;
            }
            w = Math.exp(w);
            z = -x / (1.0 - x);
            term = 1.0;
            sum = 1.0;
            int j = 1;
            while (Math.abs(term / (sum += (term *= z * ((double)j - alpha) / ((double)j + alpha)))) > eps && ++j < 2000) {
            }
            term = ((sum *= x) - w) / alpha;
            xnew = x - term;
            if (!(Math.abs(term) < 3.2E-4)) continue;
            eps = EPSILON;
        } while (Math.abs(xnew - x) > sum * EPSILON && Math.abs(xnew - x) > EPSILON && i <= 11);
        if (i >= 11 && Math.abs(xnew - x) > 10.0 * EPSILON) {
            return BetaSymmetricalDist.bisect(alpha, logBua, 0.0, 0.5, d);
        }
        return xnew;
    }

    private static double inverse4(double alpha, double logBva, int d) {
        double sum;
        double y;
        double eps = 1.0E-5;
        double EPSILON = EPSARRAY[d];
        double ynew = Math.exp(logBva);
        int i = 0;
        do {
            ++i;
            y = ynew;
            double z = 4.0 * y * y;
            sum = 1.0;
            double term = 1.0;
            int j = 1;
            while (term > (sum += (term *= z * ((double)j + alpha - 0.5) / (0.5 + (double)j))) * eps && ++j < 2000) {
            }
            term = Math.log1p(-z);
            term = (sum *= y * (1.0 - z)) - Math.exp(logBva - (alpha - 1.0) * term);
            ynew = y - term;
            if (!(Math.abs(term) < 3.2E-4)) continue;
            eps = EPSILON;
        } while (Math.abs(ynew - y) > EPSILON && Math.abs(ynew - y) > sum * EPSILON && i <= 11);
        return 0.5 - ynew;
    }

    private static double PeizerInverse(double alpha, double u) {
        double xprev;
        double C2 = alpha - 0.3333333333333333 + 0.025 / alpha;
        double z = NormalDist.inverseF01(u);
        double x = 0.5;
        double y = 1.0 - x;
        int i = 0;
        do {
            ++i;
            double t1 = (2.0 * alpha - 0.8333333333333334) * x * y;
            double t3 = 1.0 - y * BetaDist.beta_g(2.0 * x) - x * BetaDist.beta_g(2.0 * y);
            xprev = x;
            x = 0.5 + 0.5 * z * Math.sqrt(t1 / t3) / C2;
            y = 1.0 - x;
        } while (i <= 11 && Math.abs(x - xprev) > 1.0E-10);
        return x;
    }

    private static void CalcB4(double alpha, double[] bc, double epsilon) {
        double pB = 0.0;
        double plogB = 0.0;
        double plogC = 0.0;
        if (alpha <= 1.0E-10) {
            pB = 2.0 / alpha;
            plogB = Math.log(pB);
            plogC = plogB + (alpha - 1.0) * 1.3862943611198906;
        } else if (alpha <= 1.0) {
            double temp = Num.lnGamma(alpha);
            plogB = 2.0 * temp - Num.lnGamma(2.0 * alpha);
            plogC = plogB + (alpha - 1.0) * 1.3862943611198906;
            pB = Math.exp(plogB);
        } else if (alpha <= 10.0) {
            plogC = Num.lnGamma(alpha) - Num.lnGamma(0.5 + alpha) + -0.1207822376352453;
            plogB = plogC - (alpha - 1.0) * 1.3862943611198906;
            pB = Math.exp(plogB);
        } else if (alpha <= 200.0) {
            double term = 1.0;
            double sum = 1.0;
            int i = 1;
            while (term > epsilon * sum) {
                sum += (term *= ((double)i - 1.5) * ((double)i - 1.5) / ((double)i * (alpha + (double)i - 1.5)));
                ++i;
            }
            double temp = 0.886226925452758 / Math.sqrt((alpha - 0.5) * sum);
            plogC = Math.log(temp);
            plogB = plogC - (alpha - 1.0) * 1.3862943611198906;
            pB = Math.exp(plogB);
        } else {
            double z = 1.0 / (8.0 * alpha);
            double temp = 1.0 + z * (-1.0 + z * (0.5 + z * (2.5 - z * (2.625 + 49.875 * z))));
            temp = 0.886226925452758 / (Math.sqrt(alpha) * temp);
            plogC = Math.log(temp);
            plogB = plogC - (alpha - 1.0) * 1.3862943611198906;
            pB = Math.exp(plogB);
        }
        bc[0] = pB;
        bc[1] = plogB;
        bc[2] = plogC;
    }

    private static double calcInverseF(double alpha, double u, int d, double logFact, double logBeta, double logCeta, double Ceta) {
        double x;
        boolean isUpper;
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u == 0.0) {
            return 0.0;
        }
        if (u == 1.0) {
            return 1.0;
        }
        if (u == 0.5) {
            return 0.5;
        }
        if (alpha == 1.0) {
            return u;
        }
        if (alpha == 0.5) {
            double temp = Math.sin(u * 1.5707963267948966);
            return temp * temp;
        }
        if (alpha > 100000.0) {
            return BetaSymmetricalDist.PeizerInverse(alpha, u);
        }
        if (u > 0.5) {
            isUpper = true;
            u = 1.0 - u;
        } else {
            isUpper = false;
        }
        double C = 0.0;
        double B = 0.0;
        double logB = 0.0;
        double logC = 0.0;
        if (logFact == Double.MIN_NORMAL) {
            double[] bc = new double[]{0.0, 0.0, 0.0};
            BetaSymmetricalDist.CalcB4(alpha, bc, EPSARRAY[d]);
            B = bc[0];
            logB = bc[1];
            logC = bc[2];
            C = Math.exp(logC);
        } else {
            B = 1.0 / Math.exp(logFact);
            logB = logBeta;
            logC = logCeta;
            C = Ceta;
        }
        if (alpha <= 1.0) {
            double y0 = C * (0.5 - u);
            x = y0 > 0.25 ? BetaSymmetricalDist.inverse1(alpha, B * u, d) : BetaSymmetricalDist.inverse2(alpha, y0, d);
        } else if (u < 1.0 / (2.5 + 2.25 * Math.sqrt(alpha))) {
            double logBua = logB + Math.log(u * alpha);
            x = BetaSymmetricalDist.inverse3(alpha, logBua, d);
        } else {
            double logBva = logC - 0.6931471805599453 + Math.log1p(-2.0 * u);
            x = BetaSymmetricalDist.inverse4(alpha, logBva, d);
        }
        if (isUpper) {
            return 1.0 - x - 2.220446049250313E-16;
        }
        return x;
    }

    private static double calcCdf(double alpha, double x, int d, double logFact, double logBeta, double logCeta, double Ceta) {
        double u;
        boolean isUpper;
        double logB = 0.0;
        double logC = 0.0;
        double C = 0.0;
        double B = 0.0;
        double EPSILON = EPSARRAY[d];
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 1.0) {
            return 1.0;
        }
        if (x == 0.5) {
            return 0.5;
        }
        if (alpha == 1.0) {
            return x;
        }
        if (alpha == 0.5) {
            return 0.6366197723675813 * Math.asin(Math.sqrt(x));
        }
        if (alpha > 100000.0) {
            return BetaSymmetricalDist.Peizer(alpha, x);
        }
        if (x > 0.5) {
            x = 1.0 - x;
            isUpper = true;
        } else {
            isUpper = false;
        }
        if (logFact == Double.MIN_NORMAL) {
            double[] bc = new double[]{B, logB, logC};
            BetaSymmetricalDist.CalcB4(alpha, bc, EPSILON);
            B = bc[0];
            logB = bc[1];
            logC = bc[2];
            C = Math.exp(logC);
        } else {
            B = 1.0 / Math.exp(logFact);
            logB = logBeta;
            logC = logCeta;
            C = Ceta;
        }
        if (alpha <= 1.0) {
            double x0;
            if (x > 0.25) {
                double temp = -Math.log(alpha);
                x0 = alpha >= 1.0E-6 ? 0.25 + 0.005 * temp : 0.13863 + 0.01235 * temp;
            } else {
                x0 = 0.25;
            }
            u = x <= x0 ? BetaSymmetricalDist.series1(alpha, x, EPSILON) / B : 0.5 - BetaSymmetricalDist.series2(alpha, 0.5 - x, EPSILON) / C;
        } else {
            double x0 = alpha < 400.0 ? 0.5 - 0.9 / Math.sqrt(4.0 * alpha) : 0.5 - 1.0 / Math.sqrt(alpha);
            if (x0 < 0.25) {
                x0 = 0.25;
            }
            if (x <= x0) {
                double temp = (alpha - 1.0) * Math.log(x * (1.0 - x)) - logB;
                u = BetaSymmetricalDist.series3(alpha, x, EPSILON) * Math.exp(temp) / alpha;
            } else {
                double temp;
                double y = 0.5 - x;
                if (y > 0.05) {
                    temp = Math.log(1.0 - 4.0 * y * y);
                } else {
                    u = 4.0 * y * y;
                    temp = -u * (1.0 + u * (0.5 + u * (0.3333333333333333 + u * (0.25 + u * (0.2 + u * (0.16666666666666666 + u * 1.0 / 7.0))))));
                }
                temp = alpha * temp - logC;
                u = 0.5 - BetaSymmetricalDist.series4(alpha, y, EPSILON) * Math.exp(temp);
            }
        }
        if (isUpper) {
            return 1.0 - u;
        }
        return u;
    }

    public double getMean() {
        return 0.5;
    }

    public double getVariance() {
        return BetaSymmetricalDist.getVariance(this.alpha);
    }

    public double getStandardDeviation() {
        return BetaSymmetricalDist.getStandardDeviation(this.alpha);
    }

    public static double[] getMLE(double[] x, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double var = 0.0;
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            var += (x[i] - 0.5) * (x[i] - 0.5);
            if (x[i] > 0.0 && x[i] < 1.0) {
                sum += Math.log(x[i] * (1.0 - x[i]));
                continue;
            }
            sum -= 709.0;
        }
        var /= (double)n;
        Function f = new Function(sum, n);
        double[] parameters = new double[1];
        double alpha0 = (1.0 - 4.0 * var) / (8.0 * var);
        double a = alpha0 - 5.0;
        if (a <= 0.0) {
            a = 1.0E-15;
        }
        parameters[0] = RootFinder.brentDekker(a, alpha0 + 5.0, f, 1.0E-5);
        return parameters;
    }

    public static BetaSymmetricalDist getInstanceFromMLE(double[] x, int n) {
        double[] parameters = BetaSymmetricalDist.getMLE(x, n);
        return new BetaSymmetricalDist(parameters[0]);
    }

    public static double getMean(double alpha) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        return 0.5;
    }

    public static double getVariance(double alpha) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        return 1.0 / (8.0 * alpha + 4.0);
    }

    public static double getStandardDeviation(double alpha) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        return 1.0 / Math.sqrt(8.0 * alpha + 4.0);
    }

    public void setParams(double alpha, double beta, double a, double b, int d) {
        if (a >= b) {
            throw new IllegalArgumentException("a >= b");
        }
        this.decPrec = d;
        this.supportA = this.a = a;
        this.supportB = this.b = b;
        this.bminusa = b - a;
    }

    private void setParams(double alpha, int d) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        this.alpha = alpha;
        this.beta = alpha;
        double[] bc = new double[]{0.0, 0.0, 0.0};
        BetaSymmetricalDist.CalcB4(alpha, bc, EPSARRAY[d]);
        this.Beta = bc[0];
        this.logBeta = bc[1];
        this.logCeta = bc[2];
        this.Ceta = Math.exp(this.logCeta);
        this.logFactor = this.Beta > 0.0 ? -this.logBeta - (2.0 * alpha - 1.0) * Math.log(this.bminusa) : 0.0;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.alpha};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : alpha = " + this.alpha;
    }

    private static class Function
    implements MathFunction {
        protected int n;
        protected double sum;

        public Function(double sum, int n) {
            this.n = n;
            this.sum = sum;
        }

        public double evaluate(double x) {
            if (x <= 0.0) {
                return 1.0E100;
            }
            return -2.0 * (double)this.n * Num.digamma(x) + (double)this.n * 2.0 * Num.digamma(2.0 * x) + this.sum;
        }
    }
}

