/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.information;

import java.util.LinkedHashMap;
import java.util.Map;
import jdplus.toolkit.base.api.information.BasicInformationExtractor;
import jdplus.toolkit.base.api.util.WildCards;

public interface Explorable {
    public static final char SEP = '.';

    default public boolean isValid() {
        return true;
    }

    public boolean contains(String var1);

    public Map<String, Class> getDictionary();

    public <T> T getData(String var1, Class<T> var2);

    default public Object getData(String id) {
        return this.getData(id, Object.class);
    }

    public <T> Map<String, T> searchAll(String var1, Class<T> var2);

    public static String paste(String ... s) {
        switch (s.length) {
            case 0: {
                return "";
            }
            case 1: {
                return s[0];
            }
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length; ++i) {
            builder.append(s[i]);
        }
        return builder.toString();
    }

    public static String spaste(String ... s) {
        switch (s.length) {
            case 0: {
                return "";
            }
            case 1: {
                return s[0];
            }
        }
        boolean first = true;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length; ++i) {
            if (s[i] == null) continue;
            if (!first) {
                builder.append('.');
            } else {
                first = false;
            }
            builder.append(s[i]);
        }
        return builder.toString();
    }

    public static <X> Explorable of(final X source, final String prefix, final BasicInformationExtractor<X> extractor) {
        return new Explorable(){

            @Override
            public boolean contains(String id) {
                return extractor.contains(id);
            }

            @Override
            public Map<String, Class> getDictionary() {
                LinkedHashMap<String, Class> map = new LinkedHashMap<String, Class>();
                extractor.fillDictionary(prefix, map, true);
                return map;
            }

            @Override
            public <T> T getData(String id, Class<T> tclass) {
                return extractor.getData(source, id, tclass);
            }

            @Override
            public <T> Map<String, T> searchAll(String pattern, Class<T> tclass) {
                LinkedHashMap rslt = new LinkedHashMap();
                extractor.searchAll(source, new WildCards(pattern), tclass, rslt);
                return rslt;
            }
        };
    }
}

