/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x13.regarima;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.functions.levmar.LevenbergMarquardtMinimizer;
import jdplus.toolkit.base.core.math.functions.ssq.SsqFunctionMinimizer;
import jdplus.toolkit.base.core.math.linearfilters.FilterUtility;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regsarima.RegSarimaComputer;
import jdplus.toolkit.base.core.regsarima.regular.IModelEstimator;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.sarima.SarimaModel;

public class FinalEstimator
implements IModelEstimator {
    public static final String ESTIMATION = "full estimation";
    public static final String FAILED = "estimation faied";
    public static final String SPEC_CHANGED = "arima spec changed";
    private final double tsig;
    private final double eps;
    private final boolean ami;

    public static Builder builder() {
        return new Builder();
    }

    private FinalEstimator(double eps, double tsig, boolean ami) {
        this.eps = eps;
        this.tsig = tsig;
        this.ami = ami;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean estimate(RegSarimaModelling context) {
        int niter = 0;
        ProcessingLog log = context.getLog();
        log.push(ESTIMATION);
        try {
            do {
                boolean bl;
                IArimaMapping mapping = context.getDescription().mapping();
                int ndim = mapping.getDim();
                RegSarimaComputer processor = RegSarimaComputer.builder().minimizer((SsqFunctionMinimizer.Builder)LevenbergMarquardtMinimizer.builder()).precision(this.eps).startingPoint(RegSarimaComputer.StartingPoint.Multiple).computeExactFinalDerivatives(true).build();
                context.getDescription().freeArimaParameters();
                context.estimate((IRegArimaComputer)processor);
                if (ndim == 0) {
                    bl = true;
                    return bl;
                }
                if (!this.ami) {
                    bl = true;
                    return bl;
                }
                int itest = this.test(context);
                if (itest == 0) {
                    boolean bl2 = true;
                    return bl2;
                }
                if (itest <= 1) continue;
                boolean bl3 = false;
                return bl3;
            } while (niter++ < 5);
            return false;
        }
        catch (RuntimeException err) {
            log.remark(FAILED);
            boolean bl = false;
            return bl;
        }
        finally {
            log.pop();
        }
    }

    private int test(RegSarimaModelling context) {
        int nnsig;
        double t;
        double s;
        double v;
        boolean dqs;
        ModelDescription desc = context.getDescription();
        double cval = this.tsig;
        int nz = desc.getEstimationDomain().getLength();
        double cmin = nz <= 150 ? 0.15 : 0.1;
        double cmod = 0.95;
        double bmin = 999.0;
        SarimaModel m = desc.arima();
        SarimaOrders spec = m.orders();
        DoubleSeq pm = m.parameters();
        int start = 0;
        int len = spec.getP();
        boolean dpr = len > 0 && FilterUtility.checkRoots((DoubleSeq)pm.extract(start, len), (double)(1.0 / cmod));
        start += len;
        len = spec.getBp();
        boolean dps = len > 0 && FilterUtility.checkRoots((DoubleSeq)pm.extract(start, len), (double)(1.0 / cmod));
        start += len;
        len = spec.getQ();
        boolean dqr = len > 0 && FilterUtility.checkRoots((DoubleSeq)pm.extract(start, len), (double)(1.0 / cmod));
        start += len;
        len = spec.getBq();
        boolean bl = dqs = len > 0 && FilterUtility.checkRoots((DoubleSeq)pm.extract(start, len), (double)(1.0 / cmod));
        if (!(dpr || dps || dqr || dqs)) {
            return 0;
        }
        int cpr = 0;
        int cps = 0;
        int cqr = 0;
        int cqs = 0;
        double tmin = cval;
        DataBlock diag = context.getEstimation().getMax().asymptoticCovariance().diagonal();
        int k = -1;
        if (dpr) {
            v = Math.abs(pm.get(k += spec.getP()));
            s = diag.get(k);
            if (s > 0.0 && (t = v / Math.sqrt(s)) < tmin && v < cmin) {
                ++cpr;
                bmin = t;
            }
        }
        if (dps) {
            v = Math.abs(pm.get(k += spec.getBp()));
            s = diag.get(k);
            if (s > 0.0 && (t = v / Math.sqrt(s)) < tmin && v < cmin && bmin > t) {
                ++cps;
                bmin = t;
                cpr = 0;
            }
        }
        if (dqr) {
            v = Math.abs(pm.get(k += spec.getQ()));
            s = diag.get(k);
            if (s > 0.0 && (t = v / Math.sqrt(s)) < tmin && v < cmin && bmin > t) {
                ++cqr;
                bmin = t;
                cpr = 0;
                cps = 0;
            }
        }
        if (dqs) {
            v = Math.abs(pm.get(k += spec.getBq()));
            s = diag.get(k);
            if (s > 0.0 && (t = v / Math.sqrt(s)) < tmin && v < cmin && bmin > t) {
                ++cqs;
                cpr = 0;
                cps = 0;
                cqr = 0;
            }
        }
        if ((nnsig = cpr + cps + cqr + cqs) == 0) {
            return 0;
        }
        if (cpr > 0) {
            spec.setP(spec.getP() - cpr);
        } else if (cps > 0) {
            spec.setBp(spec.getBp() - cps);
        } else if (cqr > 0) {
            spec.setQ(spec.getQ() - cqr);
        } else if (cqs > 0) {
            spec.setBq(spec.getBq() - cqs);
        }
        context.getLog().info(SPEC_CHANGED, (Object)spec);
        context.setSpecification(spec);
        return nnsig;
    }

    public static class Builder {
        private double epsilon = 1.0E-4;
        private double tsig = 1.0;
        private boolean ami = false;

        public Builder precision(double precision) {
            this.epsilon = precision;
            return this;
        }

        public Builder ami(boolean ami) {
            this.ami = ami;
            return this;
        }

        public Builder tsig(double tsig) {
            this.tsig = tsig;
            return this;
        }

        public FinalEstimator build() {
            return new FinalEstimator(this.epsilon, this.tsig, this.ami);
        }
    }
}

