/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.univariate;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import lombok.NonNull;

public class SsfData
implements ISsfData {
    private final DoubleSeq data;

    public SsfData(DoubleSeq x) {
        this.data = x;
    }

    public SsfData(double[] x) {
        this.data = DoubleSeq.onMapping((int)x.length, i -> x[i]);
    }

    public double get(int pos) {
        return pos < this.data.length() ? this.data.get(pos) : Double.NaN;
    }

    @Override
    public boolean isMissing(int pos) {
        if (pos >= this.data.length()) {
            return true;
        }
        double y = this.data.get(pos);
        return !Double.isFinite(y);
    }

    public int length() {
        return this.data.length();
    }

    public void copyTo(double @NonNull [] buffer, int start) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        this.data.copyTo(buffer, start);
    }

    @NonNull
    public DoubleSeq extract(int start, int length) {
        return this.data.extract(start, length);
    }

    public String toString() {
        return DoubleSeq.format((DoubleSeq)this.data);
    }
}

