/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.functions;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.functions.IFunction;
import jdplus.toolkit.base.core.math.functions.IFunctionDerivatives;
import jdplus.toolkit.base.core.math.functions.IFunctionPoint;
import jdplus.toolkit.base.core.math.functions.IParametersDomain;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;

public class TransformedFunction
implements IFunction {
    private final ITransformation t;
    private final IFunction fn;

    public static ITransformation linearTransformation(final double a, final double b) {
        return new ITransformation(){

            @Override
            public double f(double x) {
                return a + b * x;
            }

            @Override
            public double df(double x) {
                return b;
            }

            @Override
            public double d2f(double x) {
                return 0.0;
            }
        };
    }

    public TransformedFunction(IFunction fn, ITransformation t) {
        this.fn = fn;
        this.t = t;
    }

    @Override
    public IFunctionPoint evaluate(DoubleSeq parameters) {
        return new Point(this.fn.evaluate(parameters));
    }

    @Override
    public IParametersDomain getDomain() {
        return this.fn.getDomain();
    }

    public static interface ITransformation {
        public double f(double var1);

        public double df(double var1);

        public double d2f(double var1);
    }

    class Point
    implements IFunctionPoint {
        private final IFunctionPoint yfx;

        Point(IFunctionPoint fx) {
            this.yfx = fx;
        }

        @Override
        public DoubleSeq getParameters() {
            return this.yfx.getParameters();
        }

        @Override
        public double getValue() {
            return TransformedFunction.this.t.f(this.yfx.getValue());
        }

        @Override
        public IFunction getFunction() {
            return TransformedFunction.this;
        }

        @Override
        public IFunctionDerivatives derivatives() {
            return new Derivatives(this.yfx.derivatives(), this.getValue());
        }
    }

    class Derivatives
    implements IFunctionDerivatives {
        private final IFunctionDerivatives dfx;
        private final double fx;

        Derivatives(IFunctionDerivatives dfx, double fx) {
            this.dfx = dfx;
            this.fx = fx;
        }

        @Override
        public IFunction getFunction() {
            return TransformedFunction.this;
        }

        @Override
        public DoubleSeq gradient() {
            DataBlock g = DataBlock.of(this.dfx.gradient());
            double dt = TransformedFunction.this.t.df(this.fx);
            g.mul(dt);
            return g;
        }

        @Override
        public void hessian(FastMatrix H) {
            int n = TransformedFunction.this.getDomain().getDim();
            FastMatrix h = FastMatrix.square(n);
            this.dfx.hessian(h);
            DoubleSeq grad = this.dfx.gradient();
            double dt = TransformedFunction.this.t.df(this.fx);
            double d2t = TransformedFunction.this.t.d2f(this.fx);
            h.mul(dt);
            h.addXaXt(d2t, DataBlock.of(grad));
            H.copy(h);
        }
    }
}

