/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.AbstractVFState;
import org.openscience.cdk.isomorphism.AtomMatcher;
import org.openscience.cdk.isomorphism.BondMatcher;

final class VFSubState
extends AbstractVFState {
    private final IAtomContainer container1;
    private final IAtomContainer container2;
    private final GraphUtil.EdgeToBondMap bonds1;
    private final GraphUtil.EdgeToBondMap bonds2;
    private final AtomMatcher atomMatcher;
    private final BondMatcher bondMatcher;

    VFSubState(IAtomContainer container1, IAtomContainer container2, int[][] g1, int[][] g2, GraphUtil.EdgeToBondMap bonds1, GraphUtil.EdgeToBondMap bonds2, AtomMatcher atomMatcher, BondMatcher bondMatcher) {
        super(g1, g2);
        this.container1 = container1;
        this.container2 = container2;
        this.bonds1 = bonds1;
        this.bonds2 = bonds2;
        this.atomMatcher = atomMatcher;
        this.bondMatcher = bondMatcher;
    }

    @Override
    boolean feasible(int n, int m) {
        if (!this.atomMatcher.matches(this.container1.getAtom(n), this.container2.getAtom(m))) {
            return false;
        }
        int nTerminal1 = 0;
        int nTerminal2 = 0;
        int nRemain1 = 0;
        int nRemain2 = 0;
        for (int n_prime : this.g1[n]) {
            int m_prime = this.m1[n_prime];
            if (m_prime != -1) {
                IBond bond2 = this.bonds2.get(m, m_prime);
                if (bond2 == null) {
                    return false;
                }
                if (this.bondMatcher.matches(this.bonds1.get(n, n_prime), bond2)) continue;
                return false;
            }
            if (this.t1[n_prime] > 0) {
                ++nTerminal1;
                continue;
            }
            ++nRemain1;
        }
        for (int m_prime : this.g2[m]) {
            if (this.m2[m_prime] != -1) continue;
            if (this.t2[m_prime] > 0) {
                ++nTerminal2;
                continue;
            }
            ++nRemain2;
        }
        return nTerminal1 <= nTerminal2 && nRemain1 + nTerminal1 <= nRemain2 + nTerminal2;
    }
}

