# QuantileOnQuantile 1.0.3

## Bug Fixes

* Fixed Unicode escape sequences (\\u03C4, \\u03B8, \\u03C1) in R source files 
  that were causing LaTeX errors during PDF manual generation on CRAN
* These escapes were converted to actual Greek characters when roxygen2 
  generated the .Rd files, which LaTeX could not process
* Replaced with ASCII text equivalents (tau, theta, r)

# QuantileOnQuantile 1.0.2

## Bug Fixes

* Removed all Unicode characters from package files to fix LaTeX PDF generation
* Version 1.0.1 still had Greek characters in cran-comments.md and NEWS.md

# QuantileOnQuantile 1.0.1

## Bug Fixes

* Fixed Unicode Greek characters (theta, tau) in vignette and README that caused 
  LaTeX errors during PDF manual generation
* Replaced Unicode superscript characters with ASCII equivalents

# QuantileOnQuantile 1.0.0

## Initial Release

* First public release of the QuantileOnQuantile package
* Implements the Quantile-on-Quantile regression methodology from Sim and Zhou (2015)

### New Features

* `qq_regression()` - Main function for performing QQ regression analysis
  - Supports customizable quantile grids
  - Multiple standard error estimation methods
  - Verbose progress reporting option
  
* `plot_qq_3d()` - Interactive 3D surface plots with plotly
  - MATLAB-style Jet colorscale (default)
  - Blue-Red diverging colorscale
  - Viridis and Plasma perceptually uniform scales
  - Customizable gridlines and camera angles
  
* `plot_qq_heatmap()` - 2D heatmap visualization
  - Automatic colorscale selection based on variable type
  - Customizable axis labels and titles
  
* `plot_qq_contour()` - Contour plots with labeled level curves

* `plot_qq_correlation()` - Quantile correlation heatmaps
  - Python seaborn-style blue-red diverging scale
  - Automatic annotations

* `qq_statistics()` - Summary statistics for QQ results

* `qq_to_matrix()` - Convert results to matrix format

* `qq_export()` - Export results to CSV

* `qq_colorscales()` - Display available color scales

### Documentation

* Comprehensive vignette with examples based on oil-stock relationship
* Full roxygen2 documentation for all functions
* CRAN-compliant package structure

### References

* Sim, N. and Zhou, H. (2015). Oil Prices, US Stock Return, and the 
  Dependence Between Their Quantiles. Journal of Banking & Finance, 
  55, 1-12. doi:10.1016/j.jbankfin.2015.01.013
