data{
  int N;                                 // number of patients (M(T1))
  real<lower=0> t[N];                    // observed time (t^*_{ci} in the paper)
  int<lower=0, upper=1> status[N];       // censoring status (corresponds to 1-delta_{ci}, 0 = random censored, 1 = not)
  real<lower=0> a;                       // 1st parameter of the gamma prior (shape) for lambda_0c (= alpha_c)
  real<lower=0> b;                       // 2nd parameter of the gamma prior (rate / inverse scale) for lambda_0c (= beta_c)
  real<lower=0> c;                       // 1st parameter of the gamma prior (shape) for rho_c (= alpha_rc)
  real<lower=0> d;                       // 2nd parameter of the gamma prior (rate / inverse scale) for rho_c (= beta_rc)
  }

parameters{
  real<lower=0> rho;            // shape of weibull (rho_c) ## (I removed the hard upper bound of 2)
  real<lower=0> lambda;                  // hazard scale of Weibull (lambda_0c) -- warning: this is not the time scale sigma used in stan
  }

model{
  real time_scale;
  rho ~ gamma(c,d);   // rho_c
  lambda ~ gamma(a,b); // lambda_0c
  // Stan Weibull uses time-scale sigma; we set sigma = (lambda * exp(X beta))^(-1/rho)
  // so that S(t|X) = exp(-lambda * t^rho * exp(X beta)).
  time_scale   = pow(lambda, -1.0 / rho);             // (hazard_scale)^(-1/rho)
    for (i in 1:N){
    if (status[i] == 0){ // δ_ci=1: censoring observed
      target += weibull_lpdf(t[i] | rho, time_scale);
    } else {             // status[i] == 1 => δ_ci=0: not censored up to t
      target += weibull_lccdf(t[i] | rho, time_scale);
    }
  }
}


